import { type Dict } from '@sage/xtrem-shared';
import type { Store } from 'redux';
import type { SectionControlObject } from '../component/control-objects';
import * as xtremRedux from '../redux';
import type { ConfirmationDialogOptions, AsyncLoaderDialogOptions, CustomDialogContentType, CustomDialogOptions, DialogButton, DialogButtonOptions, DialogContentType, DialogLevel, DialogOptions, DialogType, IDialogControl, LookupDialogContent, LookupDialogOptions, PageDialogOptions, TableSidebarDialogContent } from '../types/dialogs';
import type { QueryParameters } from '../utils/types';
import type { ScreenBase } from './screen-base';
/** For unit tests only */
export declare const resetDialogIds: () => void;
type DialogArgs = {
    dialogId: number;
    screenId: string | null;
    level: DialogLevel;
    title: string | undefined;
    content: DialogContentType;
    getButtons: (dialogId: number, resolve: (value?: any) => void, reject: (reason?: any) => void) => Dict<DialogButton>;
    options?: PageDialogOptions & CustomDialogOptions<ScreenBase> & ConfirmationDialogOptions<ScreenBase>;
    isSticker?: boolean;
    isDirtyCheck: boolean;
    subtitle?: string;
    readonly type?: DialogType;
    onClose?: () => void;
};
export declare class DialogControl implements IDialogControl {
    [Symbol.toStringTag]: string;
    readonly id: number;
    protected readonly dialogPromise: Promise<void>;
    private rejectPromise;
    private resolvePromise;
    private readonly dialogArgs;
    readonly onClose?: () => void;
    constructor(args: DialogArgs);
    cancel(reason?: Error): void;
    catch(callback: (dialogId: number) => any): Promise<any>;
    then<TResult1 = any, TResult2 = any>(onFulfilled?: ((value: any) => TResult1 | PromiseLike<TResult1>) | undefined | null, onRejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): Promise<TResult1 | TResult2>;
    finally(onFinally?: (() => void) | null | undefined): Promise<any>;
    resolve(value: any): void;
}
export declare class PageDialogControl extends DialogControl {
    [Symbol.toStringTag]: string;
    constructor(dialogId: number, options?: PageDialogOptions);
    resolve(value: Dict<any>): void;
    finally(onFinally?: (() => void) | null | undefined): Promise<any>;
    get promise(): Promise<void>;
}
export declare const closeDialog: ({ dialogId, result, isWizardCompleted, suppressDiscardEvent, }: {
    dialogId: number;
    result?: any;
    isWizardCompleted?: boolean;
    suppressDiscardEvent?: boolean;
}) => Promise<void>;
export declare const createDialog: <T extends DialogOptions<ScreenBase> = DialogOptions<ScreenBase>>(screenId: string, level: DialogLevel, title: string | undefined, content: DialogContentType, getButtons: (dialogId: number, resolve: (value?: any) => void, reject: (reason?: any) => void) => Dict<DialogButton>, options?: T, isSticker?: boolean, type?: DialogType, subtitle?: string, onClose?: () => void) => DialogControl;
export declare const createStickerDialog: (store: Store<xtremRedux.XtremAppState, xtremRedux.AppAction>, screenId: string, level: DialogLevel, title: string | undefined, content: SectionControlObject, options?: CustomDialogOptions<ScreenBase>) => DialogControl;
export declare const getDialogButton: (screenId: string, dialogId: number, callback: (value: any) => void, defaultText: string, buttonConfiguration?: DialogButtonOptions<any>) => DialogButton;
export declare const getAcceptButton: (screenId: string, dialogId: number, resolve: (value?: any) => void, buttonConfiguration?: DialogButtonOptions<any>) => DialogButton;
export declare const getCancelButton: (screenId: string, dialogId: number, callback: (reason?: any) => void, buttonConfiguration?: DialogButtonOptions<any>) => DialogButton;
export declare const getConfirmationButtons: (screenId: string, options?: DialogOptions<ScreenBase>) => (dialogId: number, resolve: (value?: any) => void, reject: (reason?: any) => void) => Dict<DialogButton>;
export declare const errorDialog: (screenId: string, title: string, error: Error) => void;
export declare const confirmationDialog: (screenId: string, level: DialogLevel, title: string, message: string, options?: ConfirmationDialogOptions<ScreenBase>) => DialogControl;
export declare const messageDialog: (screenId: string, level: DialogLevel, title: string | undefined, message: string, options?: DialogOptions<ScreenBase>) => DialogControl;
export declare const customDialog: (screenId: string, level: DialogLevel, content: CustomDialogContentType, options?: CustomDialogOptions<ScreenBase>) => DialogControl;
export declare const asyncLoaderDialog: (screenId: string, level: DialogLevel, nodeName: string, asyncOperationName: string, parameters: any, selector: any, options?: AsyncLoaderDialogOptions) => DialogControl;
export declare function customLookupDialog(store: {
    dispatch: xtremRedux.AppThunkDispatch;
    getState: () => xtremRedux.XtremAppState;
}, screenId: string, options: LookupDialogOptions<ScreenBase>): Promise<any[]>;
export declare const lookupDialog: (screenId: string, level: DialogLevel, options: LookupDialogContent & DialogOptions<ScreenBase>) => DialogControl;
export declare const internalDialog: (screenId: string, level: DialogLevel, content: React.ReactElement, options?: CustomDialogOptions<ScreenBase>) => DialogControl;
export declare function resolvePageDialog(resolutionValue: any): void;
export declare function pageDialog<T>(store: {
    dispatch: xtremRedux.AppThunkDispatch;
    getState: () => xtremRedux.XtremAppState;
}, path: string, queryParameters?: QueryParameters, options?: PageDialogOptions): Promise<void | T>;
export declare function openPageDialog<T>(path: string, queryParameters?: QueryParameters, options?: PageDialogOptions): Promise<void | T>;
export declare function openTableSidebarDialog(args: {
    screenId: string;
} & TableSidebarDialogContent): DialogControl;
export {};
//# sourceMappingURL=dialog-service.d.ts.map