import { asyncLoaderDialog, confirmationDialog, customDialog, customLookupDialog, messageDialog, pageDialog, } from './dialog-service';
export const getDialogApi = (screenId, store) => ({
    confirmation: (level, title, message, options) => confirmationDialog(screenId, level, title, message, options),
    message: (level, title, message, options) => messageDialog(screenId, level, title, message, options),
    custom: (level, content, options) => customDialog(screenId, level, content, options),
    page: (path, queryParameters = {}, options) => pageDialog(store, path, queryParameters, options),
    lookup: (options) => {
        return customLookupDialog(store, screenId, options);
    },
    asyncLoader: (nodeName, operation, parameters, selector, dialogOptions) => {
        return asyncLoaderDialog(screenId, 'info', String(nodeName), String(operation), parameters, selector, dialogOptions);
    },
});
//# sourceMappingURL=dialog-api.js.map