import { type AbstractResponsiveWidget, type VisualProcessProps, type WidgetCollectionItem } from '@sage/bms-dashboard';
import type { ClientNode } from '@sage/xtrem-client';
import { type Dashboard, type DashboardItem, type Dict } from '@sage/xtrem-shared';
import type { DashboardBreakpoint, WidgetDefinitionWithLoadingState } from '../dashboard/dashboard-types';
import type { AbstractWidget, WidgetDefinition } from '../dashboard/widgets/abstract-widget';
import type { DashboardListItem, OnTelemetryEventFunction } from '../redux/state';
export declare const DASHBOARD_DETAILS_QUERY: {
    _id: boolean;
    title: boolean;
    isTemplate: boolean;
    children: {
        _id: boolean;
        type: boolean;
        settings: boolean;
        positions: {
            x: boolean;
            y: boolean;
            breakpoint: boolean;
            h: boolean;
            w: boolean;
        };
    };
};
export declare const fetchCurrentDashboardDefinition: (group: string, shouldFetchPlatformLiterals?: boolean) => Promise<{
    dashboard: Dashboard | null;
    stringLiterals: Dict<string>;
    availableDashboards: DashboardListItem[] | null;
    canEditDashboards: boolean;
}>;
export declare const fetchWidgetCategories: () => Promise<Dict<string>>;
export declare const fetchDashboardTemplates: (group: string) => Promise<DashboardListItem[]>;
export declare const setSelectedDashboard: (selectedId: string, group: string) => Promise<Dashboard>;
export declare const cloneDashboard: (dashboardIdToClone: string) => Promise<Dashboard>;
export declare const deleteDashboard: (dashboardIdToDelete: string) => Promise<void>;
export declare const createEmptyDashboard: (group: string) => Promise<Dashboard>;
export declare const updateDashboard: (dashboardDefinition: Dashboard) => Promise<Dashboard>;
export interface XtremUiWidgetCategory extends ClientNode {
    title: string;
    sortValue?: number;
}
export interface XtremUiWidget extends ClientNode {
    category: XtremUiWidgetCategory;
    title: string;
    description: string;
    type: string;
}
/**
 * Fetches widget list from the server and adds "Others" category to those which doesn't have one.
 * It also adds a _sortValue as the items should be categorized alphabetically, e
 * except the Others, so we cannot sort them just by their label
 * @returns
 */
export declare const getWidgetList: (group?: string) => Promise<{
    widgets: XtremUiWidget[];
    categories: XtremUiWidgetCategory[];
}>;
export declare const refreshWidget: (widgetId: string, group: string, skipUnset?: boolean) => void;
export declare const fetchWidgetPage: ({ queryArgs, widgetId, group, }: {
    widgetId: string;
    queryArgs: LoadMoreRowsParams;
    group: string;
}) => Promise<WidgetCollectionItem[]>;
export declare const getIndicatorTileGroupWidgetConfig: (widgetId: string, widgetDefinition: WidgetDefinition, group: string, isEditing?: boolean) => Partial<AbstractResponsiveWidget>;
export type LoadMoreRowsParams = {
    startIndex: number;
    stopIndex: number;
    pageCount: number;
    pageSize: number;
    after?: WidgetCollectionItem;
    first: number;
};
export declare const getVisualProcessWidgetConfig: (widgetId: string, widgetDefinition: WidgetDefinition, group: string, isEditing?: boolean) => Partial<AbstractResponsiveWidget<VisualProcessProps>>;
export declare const getWidgetsFromDashboardItems: ({ dashboardId, group, children, widgets, isEditing, onCloseCallback, canEditDashboards, breakpoint, onTelemetryEvent, }: {
    dashboardId: string;
    group: string;
    children: DashboardItem[];
    widgets: Dict<WidgetDefinitionWithLoadingState>;
    isEditing?: boolean;
    onCloseCallback?: (widgetId: string) => void;
    canEditDashboards?: boolean;
    breakpoint: DashboardBreakpoint;
    onTelemetryEvent?: OnTelemetryEventFunction;
}) => AbstractResponsiveWidget[];
export declare const fetchWidgetData: ({ forceRefetch, locale, version, widgetDefinition, queryArgs, group, }: {
    forceRefetch?: boolean;
    locale?: string;
    version?: string;
    widgetDefinition: WidgetDefinition;
    group: string;
    queryArgs?: Partial<LoadMoreRowsParams>;
}) => Promise<any>;
export declare function resolveWidgetProperty<T>(property: T, group: string, 
/** The widget ID or the AbstractWidget object */
widget: string | AbstractWidget, ...args: any[]): T extends (...args: any) => any ? ReturnType<T> : T | undefined;
//# sourceMappingURL=dashboard-service.d.ts.map