import type { ClientNode } from '@sage/xtrem-client';
import * as xtremDecimal from '@sage/xtrem-decimal';
import type { Dict } from '@sage/xtrem-shared';
import type { NestedField, NestedFieldTypes } from '../component/nested-fields';
import type { OrderByType } from '../component/types';
import { FieldKey } from '../component/types';
import type { DateAggregation } from '../redux/state';
import type { InternalValue } from './collection-data-types';
import { RecordActionType } from './collection-data-types';
import type { FormattedNodeDetails } from './metadata-types';
import type { ScreenBase } from './screen-base';
export declare const isNumeric: (value: any) => boolean;
export type AggFunc = DateAggregation;
export declare const formatValueForSorting: (object: any, path: string, type?: NestedFieldTypes) => {
    value: string | xtremDecimal.Decimal;
    isDecimal: boolean;
};
export declare const caseInsensitiveSorting: (sortProperties: [string, boolean][], columnDefinitions: NestedField<ScreenBase, NestedFieldTypes>[]) => (obj1: any, obj2: any) => number;
export declare function transformFilterForCollectionValue(outerInput: any): any;
/**
 * Sorts a referenced ResultSet based on the received orderBy sequence
 * @param resultSet - lokijs ResultSet instance
 * @param [orderBy] - sequence of property name / sorting type (1 for asc, -1 for desc) pairs
 * @returns ResultSet
 */
export declare const sortResultSet: ({ resultSet, orderBy, columnDefinitions, }: {
    resultSet: Resultset<any>;
    orderBy?: OrderByType;
    columnDefinitions: NestedField<ScreenBase, NestedFieldTypes>[];
}) => Resultset<any>;
export declare function getGroupKey({ groupKey, type }: {
    groupKey: string;
    type: FieldKey;
}): string;
export declare const getGroupFilterValue: ({ group, mode, }: {
    group: {
        key: string;
        value?: string;
        aggFunc?: AggFunc;
        type: FieldKey;
    };
    mode: "server" | "client";
}) => any;
export declare class CollectionDataRow<T extends ClientNode> {
    private readonly input;
    private readonly columnDefinitions;
    private readonly nodes;
    private readonly nodeTypes;
    private readonly options?;
    private result;
    private readonly includeActions;
    private readonly removeNegativeId;
    private readonly isRequestingDefaults;
    private readonly cleanInputTypes;
    constructor(input: InternalValue<T>, columnDefinitions: Array<NestedField<ScreenBase, NestedFieldTypes, any>[]>, nodes: string[], nodeTypes: Dict<FormattedNodeDetails>, options?: {
        includeActions?: boolean;
        removeNegativeId?: boolean;
        isRequestingDefaults?: boolean;
        cleanInputTypes?: boolean;
        isTree?: boolean;
    } | undefined);
    protected getLevel(): number;
    protected getDirtyColumns(): Set<string> | undefined;
    protected getAction(): RecordActionType | undefined;
    protected isRemoved(): boolean;
    protected removeTransientColumns(): this;
    protected removeComputedColumns(): this;
    protected cleanupRemoved(): this;
    protected cleanMetadataFromRecord(): this;
    protected removeNonInputTypes(): this;
    protected extractDirty(): this;
    protected cloneAction(): this;
    protected deleteNegativeId(): this;
    protected removeNullOnlyLeaves(): this;
    protected splitValueToMergedValue(): this;
    getChangeset(): any;
    private readonly getNode;
    private readonly getColumnDefinitions;
}
//# sourceMappingURL=collection-data-utils.d.ts.map