import type { EditableFieldProperties } from '../component/editable-field-control-object';
import type { BaseEditableComponentProperties, NestedFieldsAdditionalProperties } from '../component/field/field-base-component-types';
import * as React from 'react';
import type { Dict } from '@sage/xtrem-shared';
import type { HasOptionType } from '../component/field/traits';
import { FieldKey } from '../component/types';
type fieldType = FieldKey.Select | FieldKey.DropdownList | FieldKey.Radio | FieldKey.MultiDropdown;
interface SelectLikeFieldWrapperExternalProps extends BaseEditableComponentProperties<EditableFieldProperties & HasOptionType, any, NestedFieldsAdditionalProperties> {
    fieldType: fieldType;
}
export interface SelectLikeFieldWrapperProps extends SelectLikeFieldWrapperExternalProps {
    localizedOptions?: Dict<string>;
    enumOptions?: string[];
}
export declare function SelectLikeFieldWrapper(props: SelectLikeFieldWrapperProps): React.ReactElement;
export declare const ConnectedSelectLikeFieldWrapper: import("react-redux").ConnectedComponent<typeof SelectLikeFieldWrapper, {
    fieldType: fieldType;
    bind?: import("..").PropertyValueType<import("@sage/xtrem-client").ClientNode | any>;
    elementId: string;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    item?: import("..").PageArticleItem | undefined;
    screenId: string;
    contextType?: import("../types").ContextType | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isUsingInfiniteScroll?: boolean | undefined;
    validationErrors?: import("..").ValidationResult[] | undefined;
    setFieldValue: (bind: string, value: any) => Promise<void>;
    validate: (bind: string, value: any) => Promise<import("..").ValidationResult[] | undefined>;
    removeNonNestedErrors: (bind: string) => void;
    setFieldProperties?: ((elementId: string, value: EditableFieldProperties<import("../service/screen-base").ScreenBase<any, any>, any> & HasOptionType) => void) | undefined;
    isParentReadOnly?: boolean | undefined;
    browser?: import("../plugin").ReduxResponsive | undefined;
    fieldProperties: EditableFieldProperties<import("../service/screen-base").ScreenBase<any, any>, any> & HasOptionType;
    nodeTypes?: Dict<import("../service/metadata-types").FormattedNodeDetails> | undefined;
    pageNode?: import("../types").NodePropertyType | undefined;
    value?: any;
    onFocus: (row?: string, nestedField?: string) => void;
    isInFocus?: boolean | undefined;
    locale: import("@sage/xtrem-shared").LocalizeLocale;
    columnDefinition?: any;
    contextNode?: import("../types").NodePropertyType | undefined;
    handlersArguments?: import("../component/nested-fields").NestedFieldHandlersArguments | undefined;
    isNested?: boolean | undefined;
    level?: number | undefined;
    parentElementId?: string | undefined;
    recordContext?: any;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export {};
//# sourceMappingURL=select-like-field-wrapper.d.ts.map