import * as React from 'react';
import { ConnectedBlockComponent } from '../component/container/block/block-component';
import { AsyncGridRowBlockComponent } from '../component/container/grid-row-block/async-grid-row-block';
import { ConnectedSectionComponent } from '../component/container/section/section-component';
import { ConnectedTileComponent } from '../component/container/tile/tile-component';
import FieldWrapper from './field-wrapper';
export class RenderingRouterProps {
}
export const RenderingRouter = React.memo((props) => {
    if (props.item.$bind) {
        return (React.createElement(FieldWrapper, { screenId: props.screenId, item: props.item, contextType: props.contextType, availableColumns: props.availableColumns, isParentDisabled: props.isParentDisabled, isParentHidden: props.isParentHidden, isUsingInfiniteScroll: props.isUsingInfiniteScroll }));
    }
    if (props.item.$layout) {
        switch (props.item.$category) {
            case 'section':
                return (React.createElement(ConnectedSectionComponent, { availableColumns: props.availableColumns, contextType: props.contextType, hasFooter: props.hasFooter, isParentDisabled: props.isParentDisabled, isParentHidden: props.isParentHidden, item: props.item, screenId: props.screenId, isUsingInfiniteScroll: props.isUsingInfiniteScroll }));
            case 'block':
                return (React.createElement(ConnectedBlockComponent, { screenId: props.screenId, item: props.item, contextType: props.contextType, availableColumns: props.availableColumns, isParentDisabled: props.isParentDisabled, isParentHidden: props.isParentHidden }));
            case 'tile':
                return (React.createElement(ConnectedTileComponent, { screenId: props.screenId, item: props.item, contextType: props.contextType, availableColumns: props.availableColumns, isParentDisabled: props.isParentDisabled, isParentHidden: props.isParentHidden }));
            case 'grid-row-block':
                return (React.createElement(AsyncGridRowBlockComponent, { screenId: props.screenId, item: props.item, contextType: props.contextType, availableColumns: props.availableColumns, isParentDisabled: props.isParentDisabled, isParentHidden: props.isParentHidden }));
            default:
                return (React.createElement("div", null,
                    "Unhandled container:",
                    props.item.$category));
        }
    }
    else {
        throw new Error(`Invalid article item:${JSON.stringify(props.item, null, 4)}`);
    }
});
RenderingRouter.displayName = 'Accordion';
//# sourceMappingURL=rendering-router.js.map