import * as React from 'react';
import { connect } from 'react-redux';
import { AsyncAggregateComponent } from '../component/field/aggregate/async-aggregate-component';
import { AsyncCheckboxComponent } from '../component/field/checkbox/async-checkbox-component';
import { AsyncCountComponent } from '../component/field/count/async-count-component';
import { AsyncDateComponent } from '../component/field/date/async-date-component';
import { AsyncProgressComponent } from '../component/field/progress/async-progress-component';
import * as xtremRedux from '../redux';
import { executeValidationRulesOnField } from '../service/validation-service';
import { getElementAccessStatus } from '../utils/access-utils';
import { getPageDefinitionFromState } from '../utils/state-utils';
import { AsyncReferenceComponent } from '../component/field/reference/async-reference-component';
import { AsyncTextAreaComponent } from '../component/field/text-area/async-text-area-component';
import { AsyncTextComponent } from '../component/field/text/async-text-component';
import { AsyncSwitchComponent } from '../component/field/switch/async-switch-component';
import { AsyncLinkComponent } from '../component/field/link/async-link-component';
import { AsyncNumericComponent } from '../component/field/numeric/async-numeric-component';
import { AsyncIconComponent } from '../component/field/icon/async-icon-component';
import { AsyncLabelComponent } from '../component/field/label/async-label-component';
import { AsyncImageComponent } from '../component/field/image/async-image-component';
import { AsyncMultiReferenceComponent } from '../component/field/multi-reference/async-multi-reference-component';
import { AsyncRelativeDateComponent } from '../component/field/relative-date/async-relative-date-component';
import { FieldKey } from '../component/types';
import { normalizeUnderscoreBind } from '../utils/abstract-fields-utils';
import { ConnectedSelectLikeFieldWrapper } from './select-like-field-wrapper';
import { AsyncFilterSelectComponent } from '../component/field/filter-select/async-filter-select-component';
import { AsyncDatetimeRangeComponent } from '../component/field/datetime-range/async-datetime-range-component';
import { AsyncDynamicSelectComponent } from '../component/field/dynamic-select/async-dynamic-select-component';
import { AsyncDatetimeComponent } from '../component/field/datetime/async-datetime-component';
export class NestedFieldWrapper extends React.Component {
    constructor() {
        super(...arguments);
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        this.removeNonNestedErrors = (_bind) => {
            return undefined;
        };
        this.validate = async (columnName, value) => {
            if (this.props.validate) {
                return this.props.validate(columnName, value);
            }
            const result = await executeValidationRulesOnField({
                screenId: this.props.screenId,
                elementId: this.props.parentElementId,
                value,
                columnId: columnName,
                fieldProperties: this.props.columnDefinition.properties,
                recordId: this.props._id,
                rowValue: this.props.recordContext,
            });
            const filteredResult = result.filter(v => !!v.message);
            this.props.updateNestedFieldValidationErrors(this.props.screenId, this.props.parentElementId, filteredResult, columnName, this.props._id);
            return filteredResult;
        };
    }
    renderElement() {
        const readOnlyProperties = {
            contextType: this.props.contextType,
            elementId: this.props.columnName,
            columnDefinition: this.props.columnDefinition,
            fieldProperties: this.props.columnProperties,
            handlersArguments: this.props.handlersArguments,
            screenId: this.props.screenId,
            nestedReadOnlyField: this.props.nestedReadOnlyField,
            shouldRenderLabelInNestedReadOnlyMode: this.props.shouldRenderLabelInNestedReadOnlyMode,
            value: this.props.value,
            locale: this.props.locale,
            availableColumns: 1,
            parentElementId: this.props.parentElementId,
            // CC: This was never being called at the time of development (X3-180847)
            onFocus: () => {
                this.props.onFocus(this.props.screenId, this.props.parentElementId, this.props._id, this.props.columnName);
            },
            isInFocus: !!this.props.focusPosition &&
                this.props.screenId === this.props.focusPosition.screenId &&
                this.props.parentElementId === this.props.focusPosition.elementId &&
                this.props.columnName === this.props.focusPosition.nestedField &&
                this.props._id === this.props.focusPosition.row,
            isNested: true,
            isParentDisabled: this.props.accessRule === 'unauthorized',
        };
        const editableProperties = {
            ...readOnlyProperties,
            setFieldValue: this.props.setFieldValue,
            removeNonNestedErrors: this.removeNonNestedErrors,
            validate: this.validate,
            recordContext: this.props.recordContext,
            validationErrors: this.props.validationErrors?.filter(e => (e.columnId || e.recordId) === normalizeUnderscoreBind(this.props.columnName)) || [],
            isParentReadOnly: this.props.isParentReadOnly,
        };
        switch (this.props.columnDefinition.type) {
            case FieldKey.Aggregate:
                const aggregateProperties = {
                    ...readOnlyProperties,
                    fieldProperties: readOnlyProperties.fieldProperties,
                };
                return React.createElement(AsyncAggregateComponent, { ...aggregateProperties });
            case FieldKey.Checkbox:
                return React.createElement(AsyncCheckboxComponent, { ...editableProperties });
            case FieldKey.Count:
                return React.createElement(AsyncCountComponent, { ...readOnlyProperties });
            case FieldKey.Date:
                return React.createElement(AsyncDateComponent, { ...editableProperties });
            case FieldKey.DatetimeRange:
                return React.createElement(AsyncDatetimeRangeComponent, { ...editableProperties });
            case FieldKey.DynamicSelect:
                const dynamicSelectProperties = {
                    ...editableProperties,
                    fieldProperties: readOnlyProperties.fieldProperties,
                };
                return React.createElement(AsyncDynamicSelectComponent, { ...dynamicSelectProperties });
            case FieldKey.Progress:
                return React.createElement(AsyncProgressComponent, { ...readOnlyProperties });
            case FieldKey.Icon:
                return React.createElement(AsyncIconComponent, { ...readOnlyProperties });
            case FieldKey.Image:
                return React.createElement(AsyncImageComponent, { ...editableProperties });
            case FieldKey.Label:
                return React.createElement(AsyncLabelComponent, { ...readOnlyProperties });
            case FieldKey.Link:
                return React.createElement(AsyncLinkComponent, { ...readOnlyProperties });
            case FieldKey.MultiReference:
                return (React.createElement(AsyncMultiReferenceComponent, { ...editableProperties, contextNode: this.props.contextNode }));
            case FieldKey.Numeric:
                return React.createElement(AsyncNumericComponent, { ...editableProperties });
            case FieldKey.Reference:
                return (React.createElement(AsyncReferenceComponent, { ...editableProperties, contextNode: this.props.contextNode }));
            case FieldKey.Select:
            case FieldKey.MultiDropdown:
            case FieldKey.DropdownList:
                return (React.createElement(ConnectedSelectLikeFieldWrapper, { ...editableProperties, fieldType: this.props.columnDefinition.type }));
            case FieldKey.Datetime:
                return React.createElement(AsyncDatetimeComponent, { ...editableProperties });
            case FieldKey.Switch:
                return React.createElement(AsyncSwitchComponent, { ...editableProperties });
            case FieldKey.Text:
                return React.createElement(AsyncTextComponent, { ...editableProperties });
            case FieldKey.TextArea:
                return React.createElement(AsyncTextAreaComponent, { ...editableProperties });
            case FieldKey.RelativeDate:
                return React.createElement(AsyncRelativeDateComponent, { ...readOnlyProperties });
            case FieldKey.FilterSelect:
                return (React.createElement(AsyncFilterSelectComponent, { ...editableProperties, recordContext: this.props.recordContext }));
            default:
                return (React.createElement("div", null,
                    "Unhandled field:",
                    this.props.columnDefinition.type));
        }
    }
    render() {
        if (this.props.accessRule === 'unavailable') {
            return null;
        }
        return (React.createElement("div", { className: `e-field-nested e-field-nested-${this.props._id}-${this.props.columnName}` }, this.renderElement()));
    }
}
const mapStateToProps = (state, props) => {
    const accessBindings = getPageDefinitionFromState(props.screenId, state).accessBindings || {};
    const accessRule = getElementAccessStatus({
        accessBindings,
        bind: props.columnProperties.bind,
        elementProperties: props.columnProperties,
        contextNode: props.contextNode,
        nodeTypes: state.nodeTypes,
        dataTypes: state.dataTypes,
    });
    return {
        ...props,
        accessRule,
        focusPosition: props.focusPosition !== undefined ? props.focusPosition : state.focusPosition,
        locale: state.applicationContext?.locale || 'base',
        updateNestedFieldValidationErrors: xtremRedux.actions.actionStub,
        navigate: xtremRedux.actions.actionStub,
        onFocus: xtremRedux.actions.actionStub,
    };
};
const mapDispatchToProps = (dispatch) => ({
    updateNestedFieldValidationErrors: (screenId, elementId, errors, columnName, recordId) => {
        dispatch(xtremRedux.actions.updateNestedFieldValidationErrors(screenId, elementId, errors, columnName, recordId));
    },
    navigate: (path, queryParameters = {}) => dispatch(xtremRedux.actions.navigate(path, queryParameters)),
    onFocus: (screenId, elementId, row, nestedField) => dispatch(xtremRedux.actions.setFocusPosition(screenId, elementId, row, nestedField)),
});
export const ConnectedNestedFieldWrapper = connect(mapStateToProps, mapDispatchToProps)(NestedFieldWrapper);
//# sourceMappingURL=nested-field-wrapper.js.map