import { applyMiddleware, compose, createStore } from 'redux';
import { responsiveStoreEnhancer } from 'redux-responsive';
import reduxThunkMiddleware from 'redux-thunk';
import { isDevMode } from '../utils/window';
import { actionSubscriptionMiddleware } from './middleware/action-subscription-middleware';
import { dashboardWidgetsLoadMiddleware } from './middleware/dashboard-widgets-load-middleware';
import { loggingMiddleware } from './middleware/logging-middleware';
import { websocketCallbackMiddleware } from './middleware/websocket-middleware';
import rootReducer from './reducer';
const composeEnhancers = (isDevMode() && window && window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__) || compose;
const configureStore = () => {
    const middleWares = [
        reduxThunkMiddleware,
        loggingMiddleware,
        actionSubscriptionMiddleware,
        dashboardWidgetsLoadMiddleware,
        websocketCallbackMiddleware,
    ];
    const enhancer = composeEnhancers(responsiveStoreEnhancer, applyMiddleware(...middleWares));
    return createStore(rootReducer, undefined, enhancer);
};
const store = configureStore();
export const getStore = () => store;
//# sourceMappingURL=store.js.map