import { combineReducers } from 'redux';
import { ActionType } from '../action-types';
const initialState = {
    activeSubscriptions: new Map(),
};
export const subscriptions = (state = initialState, action) => {
    switch (action.type) {
        case ActionType.SubscribeToEvent: {
            const { category, callback } = action.value;
            const newSubscriptions = new Map(state.activeSubscriptions);
            const callbacks = newSubscriptions.get(category) || new Set();
            callbacks.add(callback);
            newSubscriptions.set(category, callbacks);
            return {
                ...state,
                activeSubscriptions: newSubscriptions,
            };
        }
        case ActionType.UnsubscribeFromEvent: {
            const { category, callback } = action.value;
            const newSubscriptions = new Map(state.activeSubscriptions);
            const callbacks = newSubscriptions.get(category);
            if (callbacks) {
                callbacks.delete(callback);
                if (callbacks.size === 0) {
                    newSubscriptions.delete(category);
                }
                else {
                    newSubscriptions.set(category, callbacks);
                }
            }
            return {
                ...state,
                activeSubscriptions: newSubscriptions,
            };
        }
        case ActionType.ClearAllSubscriptions:
            return {
                ...state,
                activeSubscriptions: new Map(),
            };
        default:
            return state;
    }
};
export const websocket = combineReducers({
    subscriptions,
});
//# sourceMappingURL=websocket.js.map