import { ActionType } from '../action-types';
export const toasts = (state = [], action) => {
    if (action.type === ActionType.ShowToast) {
        return [...state, action.value];
    }
    if (action.type === ActionType.RemoveToast) {
        const newState = [...state];
        const toastIndex = newState.findIndex(n => n.id === action.value);
        newState[toastIndex] = { ...newState[toastIndex], isDismissed: true };
        if (newState.find(n => !n.isDismissed)) {
            return newState;
        }
        return [];
    }
    if (action.type === ActionType.RemoveToasts) {
        return [];
    }
    return state;
};
//# sourceMappingURL=toasts.js.map