import { objectKeys } from '@sage/xtrem-shared';
import { ActionType } from '../action-types';
const remapEnumValues = (enumValues) => objectKeys(enumValues).reduce((prevValue, key) => ({ ...prevValue, [key]: enumValues[key].values }), {});
export const enumTypes = (state = {}, action) => {
    if (action.type === ActionType.AddEnumType) {
        return { ...state, ...remapEnumValues(action.value.enums) };
    }
    if (action.type === ActionType.FinishScreenLoading) {
        return { ...state, ...remapEnumValues(action.value.enumTypes) };
    }
    if (action.type === ActionType.AddSchemaInfo) {
        return { ...state, ...remapEnumValues(action.value.enumTypes) };
    }
    if (action.type === ActionType.SetInitialMetaData) {
        return { ...state, ...remapEnumValues(action.value.enumTypes) };
    }
    return state;
};
//# sourceMappingURL=enum-types.js.map