import { xtremConsole } from '../../utils/console';
import { ActionType } from '../action-types';
export const websocketCallbackMiddleware = (store) => (next) => (action) => {
    if (action.type === ActionType.TriggerCategoryCallbacks) {
        const { category, args } = action.value;
        const state = store.getState();
        const callbacks = state.websocket.subscriptions.activeSubscriptions.get(category);
        if (callbacks) {
            callbacks.forEach(callback => {
                try {
                    callback(...args);
                }
                catch (error) {
                    xtremConsole.error(`Error executing event callback for category ${category}:`, error);
                }
            });
        }
    }
    return next(action);
};
//# sourceMappingURL=websocket-middleware.js.map