import { ActionType } from '../action-types';
import { resetWidgetLoadingTimeout, setWidgetLoadingTimeoutId } from '../actions';
import { DASHBOARD_WIDGETS_MIN_LOADING_TIME } from '../../utils/constants';
export const dashboardWidgetsLoadMiddleware = (store) => (next) => (action) => {
    const result = next(action);
    if (action.type === ActionType.SetWidgetLoading) {
        const state = store.getState().loading.widgets[action.value.widgetId];
        if (!state.isActualLoading && state.isVisibleLoading && state.loadingStartTime !== null) {
            const elapsedTime = Date.now() - state.loadingStartTime;
            if (elapsedTime < DASHBOARD_WIDGETS_MIN_LOADING_TIME) {
                const remainingTime = DASHBOARD_WIDGETS_MIN_LOADING_TIME - elapsedTime;
                const timeoutId = window.setTimeout(() => {
                    store.dispatch(resetWidgetLoadingTimeout(action.value.widgetId));
                }, remainingTime);
                store.dispatch(setWidgetLoadingTimeoutId(action.value.widgetId, timeoutId));
            }
        }
    }
    return result;
};
//# sourceMappingURL=dashboard-widgets-load-middleware.js.map