import { objectKeys } from '@sage/xtrem-shared';
import { fetchWidgetCategories } from '../../service/dashboard-service';
import { fetchNodeNames } from '../../service/node-information-service';
import { GraphQLTypes } from '../../types';
import { deepFindPropertyValues } from '../../utils/common-util';
import { ActionType } from '../action-types';
export const openWidgetEditorDialog = (group, widgetId, widgetDefinition) => async (dispatch, getState) => {
    const state = getState();
    if (objectKeys(state.dashboard.nodeNames).length === 0) {
        const nodeNames = await fetchNodeNames();
        dispatch({ type: ActionType.SetNodeNames, value: nodeNames });
    }
    if (objectKeys(state.dashboard.widgetCategories).length === 0) {
        const categories = await fetchWidgetCategories();
        dispatch({ type: ActionType.SetWidgetCategories, value: { categories } });
    }
    dispatch({
        type: ActionType.SetWidgetEditorOpen,
        value: {
            isOpen: true,
            widgetId,
            widgetDefinition,
            group,
        },
    });
};
export const closeWidgetEditorDialog = (group) => ({
    type: ActionType.SetWidgetEditorOpen,
    value: { isOpen: false, group },
});
export const updateUserWidgetDefinition = (widgetDefinition, group) => {
    const copiedWidgetDefinition = { ...widgetDefinition };
    // Extract list of used enums so we can load them next time the dashboard is accessed.
    copiedWidgetDefinition.usedEnums = deepFindPropertyValues('node', widgetDefinition, (v) => v.type === GraphQLTypes.Enum);
    return {
        type: ActionType.UpdateUserWidgetDefinition,
        value: { widget: copiedWidgetDefinition, group },
    };
};
//# sourceMappingURL=widget-editor-actions.js.map