import type { ValidationResult } from '../../service/screen-base-definition';
import type { Dict } from '@sage/xtrem-shared';
import type { AppAction } from '../action-types';
export declare const setFieldValidationErrors: (screenId: string, elementId: string, errors: ValidationResult[] | ValidationResult) => AppAction;
export declare const removeNonNestedErrors: (screenId: string, elementId: string, columnId?: string) => AppAction;
export declare const updateNestedFieldValidationErrors: (screenId: string, elementId: string, validationErrors: ValidationResult[], columnId: string, recordId?: string) => AppAction;
export declare const updateNestedFieldValidationErrorsForRecord: ({ screenId, elementId, validationErrors, recordId, isUncommitted, level, }: {
    screenId: string;
    elementId: string;
    validationErrors: ValidationResult[];
    recordId: string;
    isUncommitted: boolean;
    level?: number;
}) => AppAction;
export declare const setPageValidationErrors: (screenId: string, validationErrors: Dict<ValidationResult[] | undefined>) => AppAction;
export declare const addInternalError: (screenId: string, elementId: string, errorMessage: ValidationResult) => AppAction;
export declare const removeInternalError: (screenId: string, elementId: string) => AppAction;
export declare const removePageServerErrors: (screenId: string) => AppAction;
export declare const removePhantomErrors: (screenId: string, elementId: string) => AppAction;
//# sourceMappingURL=validation-actions.d.ts.map