import * as xtremRedux from '..';
import type { UiComponentProperties } from '../../component/control-objects';
import type { Dict } from '@sage/xtrem-shared';
import type { NodePropertyType } from '../../types';
import type { HasTunnel, HasValueField } from '../../component/field/traits';
export interface TunnelSegment {
    screenId: string;
    label: string;
}
export interface OpenTunnelArgs {
    screenId: string;
    elementId: string;
    fieldProperties: HasTunnel<any> & HasValueField<any> & UiComponentProperties<any>;
    value: any;
    parentElementId?: string;
    recordContext?: Dict<any>;
    level?: number;
    contextNode?: NodePropertyType;
}
export declare const openTunnel: ({ screenId, elementId, fieldProperties, value, parentElementId, recordContext, level, contextNode, }: OpenTunnelArgs) => (_dispatch: xtremRedux.AppThunkDispatch, getState: () => xtremRedux.XtremAppState) => Promise<any>;
export declare const closeTunnelByBreadcrumbLink: (screenId: string, triggerScreenId: string) => (dispatch: xtremRedux.AppThunkDispatch, getState: () => xtremRedux.XtremAppState) => Promise<void>;
//# sourceMappingURL=tunnel-actions.d.ts.map