import { type Dict } from '@sage/xtrem-shared';
import type { FormattedNodeDetails } from '../../service/metadata-types';
import type { PageDefinition } from '../../service/page-definition';
import type { QueryParameters } from '../../utils/types';
import type { AppAction, AppThunkDispatch } from '../action-types';
import * as xtremRedux from '../index';
import type { XtremAppState } from '../state';
export declare const addQueryParametersToPath: (path: string, queryParameters: QueryParameters) => string;
export declare const getQueryParametersFromPath: (urlPart: string) => any;
export interface GetPageValuesParams {
    clean?: boolean;
    nodeTypes: Dict<FormattedNodeDetails>;
    recordId: string | null;
    requiredSections?: string[];
    screenDefinition: PageDefinition;
}
export declare const getPageValues: ({ clean, nodeTypes, recordId, requiredSections, screenDefinition, }: GetPageValuesParams) => Promise<any>;
export declare const triggerPostNavigationToasts: (state: XtremAppState, path: string, queryParameters: QueryParameters) => Promise<void>;
/**
 * Be aware that base64 encoded parameters in the path will override the queryParameters object
 * @param path Be
 * @param queryParameters
 */
export declare const navigate: (path: string, queryParameters?: QueryParameters, navigatingFromMenu?: boolean) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const selectRecord: (screenId: string, recordId: string | null, clean?: boolean) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const findNavPanelRecordLocation: (screenId: string, state: XtremAppState, offset: 1 | -1) => Promise<string | null>;
export declare const selectNextRecord: (screenId: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const selectFirstRecord: (screenId: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const selectPreviousRecord: (screenId: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const goHome: () => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const setIdToQueryParameters: (screenId: string, _id: string) => AppAction;
export declare const update360ViewInPath: (enable360: boolean) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
export declare const goBack: () => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
//# sourceMappingURL=router-actions.d.ts.map