import { ActionType } from '../action-types';
export const addMenuItem = (menuItem) => async (dispatch, getState) => {
    await dispatch({ type: ActionType.AddMenuItem, value: menuItem });
    const updatedState = getState();
    updatedState.applicationContext?.updateMenu(updatedState.menuItems);
};
export const updateMenuItem = (menuItemId, badgeContent) => async (dispatch, getState) => {
    await dispatch({ type: ActionType.UpdateMenuItem, value: { id: menuItemId, badgeContent } });
    const updatedState = getState();
    updatedState.applicationContext?.updateMenu(updatedState.menuItems);
};
export const removeMenuItem = (menuItemId) => async (dispatch, getState) => {
    await dispatch({ type: ActionType.RemoveMenuItem, value: menuItemId });
    const updatedState = getState();
    updatedState.applicationContext?.updateMenu(updatedState.menuItems);
};
//# sourceMappingURL=menu-actions.js.map