import { type Dict } from '@sage/xtrem-shared';
import type { DialogControl } from '../../service/dialog-service';
import type { DialogDescription } from '../../types/dialogs';
import type { QueryParameters } from '../../utils/types';
import type { AppThunkDispatch } from '../action-types';
import type { XtremAppState } from '../state';
export declare const closeDialog: (dialogId: number) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const openDialog: (dialogId: number, dialog: DialogDescription) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
export declare const loadPageDialogContent: (path: string, queryParameters?: QueryParameters, 
/**
 * If the values are provided, they are not fetched from the server.
 * This feature is used to pre-populate page dialogs with data.
 *  */
values?: Dict<any>, onFinish?: (values?: Dict<any>) => void, isDuplicate?: boolean) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<string | null>;
export declare const openFieldInDialog: (screenId: string, elementId: string) => (_dispatch: AppThunkDispatch, getState: () => XtremAppState) => DialogControl;
//# sourceMappingURL=dialog-actions.d.ts.map