import { type Dict } from '@sage/xtrem-shared';
import type { DashboardContextVariables } from '../../dashboard/dashboard-types';
import type { AbstractWidget, WidgetDefinition } from '../../dashboard/widgets/abstract-widget';
import { type LoadMoreRowsParams } from '../../service/dashboard-service';
import type { Constructible } from '../../types';
import type { AppAction, AppThunkDispatch } from '../action-types';
import type { XtremAppState } from '../state';
/**
 * Constructs the widget object depending its type. It checks if the widget is generic user configured or functional code provided, then constructs it.
 */
export declare const createWidgetObject: ({ contextVariables, dashboardId, group, settings, type, widgetConstructors, widgetId, }: {
    contextVariables?: DashboardContextVariables;
    dashboardId: string;
    group: string;
    settings?: any;
    type: string;
    widgetConstructors: Dict<Constructible<AbstractWidget>>;
    widgetId: string;
}) => AbstractWidget;
export declare const refreshCurrentDashboard: (group: string, contextVariables?: DashboardContextVariables) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const fetchUserDashboardDefinition: (group: string, contextVariables?: DashboardContextVariables) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const setSelectedDashboard: (id: string, group: string, contextVariables?: DashboardContextVariables) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
/**
 * Clone a dashboard based on its ID, then marks it automatically selected
 * @param idToClone
 * @returns
 */
export declare const cloneDashboard: (idToClone: string, group: string, contextVariables?: DashboardContextVariables) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
/**
 * Creates an empty dashboard, then marks it automatically selected
 * @param idToClone
 * @returns
 */
export declare const createEmptyDashboard: (group: string, contextVariables?: DashboardContextVariables) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const deleteDashboard: (dashboardId: string, group: string, contextVariables?: DashboardContextVariables) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare function getNewTableData({ widgetDefinition, data, }: {
    widgetDefinition: WidgetDefinition;
    data: any;
    group: string;
}): any;
export declare const loadWidgetData: ({ widgetId, group, forceRefetch, queryArgs, dataMode, skipUnset, }: {
    widgetId: string;
    group: string;
    forceRefetch?: boolean;
    queryArgs?: LoadMoreRowsParams;
    dataMode?: "SET" | "ADD";
    skipUnset?: boolean;
}) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<any[]>;
export declare const setWidgetOptions: (dashboardId: string, widgetId: string, group: string, options: any) => AppAction;
export declare const SetWidgetLoading: (widgetId: string, isLoading: boolean) => AppAction;
export declare const setWidgetLoadingTimeoutId: (widgetId: string, timeoutId: number | null) => AppAction;
export declare const resetWidgetLoadingTimeout: (widgetId: string) => AppAction;
export declare const removeDashboardGroup: (screenId: string) => AppAction;
//# sourceMappingURL=dashboard-actions.d.ts.map