import type { Dict } from '@sage/xtrem-shared';
import type { UiComponentProperties as dirtyStateActions } from '../../component/abstract-ui-control-object';
import type { PageControlObject } from '../../component/control-objects';
import type { DataTypeDetails, FormattedNodeDetails } from '../../service/metadata-types';
import type { XtremUiPlugin } from '../../service/plugin-service';
import type { ScreenBaseDefinition } from '../../service/screen-base-definition';
import { WIZARD_FINISHED } from '../../utils/constants';
import type { AppAction, AppThunkDispatch } from '../action-types';
import type { ApplicationContext, XtremAppState } from '../state';
export declare const setPath: (path: string) => AppAction;
export declare const setComponentLoading: (screenId: string, elementId: string, isLoading: boolean) => AppAction;
export declare const setApplicationContext: (applicationContext: ApplicationContext) => AppAction;
export declare const finishScreenLoading: (pageDefinition: ScreenBaseDefinition, nodeTypes: Dict<FormattedNodeDetails>, dataTypes: Dict<DataTypeDetails>, enumTypes: Dict<{
    name: string;
    values: string[];
    translations: string[];
}>, locale: string) => AppAction;
export declare const addSchemaInfo: (nodeTypes: Dict<FormattedNodeDetails>, dataTypes: Dict<DataTypeDetails>, enumTypes: Dict<{
    name: string;
    values: string[];
    translations: string[];
}>, locale: string) => AppAction;
export declare const addScreenDefinition: (pageDefinition: ScreenBaseDefinition) => AppAction;
export declare const addPlugin: (pluginPackage: string, pluginDefinition: XtremUiPlugin<any, any>) => AppAction;
export declare const setScreenDefinitionReady: (screenId: string) => AppAction;
export declare const setScreenDefinitionDialogId: (screenId: string, dialogId: number, pageControlObject: PageControlObject, title: string, subtitle: string, forceSetTitle?: boolean) => AppAction;
export declare const removeScreenDefinition: (screenId: string) => AppAction;
export declare const setFieldProperties: (screenId: string, elementId: string, fieldProperties: dirtyStateActions) => AppAction;
export declare const setGlobalLoading: (loaderState: boolean) => AppAction;
export declare const actionStub: () => any;
export declare const fetchTranslationByPackage: (packageKey: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const addTranslations: (locale: string, literals: Dict<string>) => AppAction;
export declare const setInitialMetaData: (applicationContext: ApplicationContext) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const clearWidgetOptions: () => AppAction;
export declare const setPageHeaderSectionClosed: ({ screenId, isClosed }: {
    screenId: string;
    isClosed: boolean;
}) => AppAction;
export declare const set360ViewState: (screenId: string, state: boolean, isUsingButton?: boolean) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
/**
 * Sets the active section in the state
 * @param screenId
 * @param activeSection the ID of the active section OR `WIZARD_FINISHED` token if the user is stepping to close the widget.
 * @param isInitialLoad
 * @returns
 */
export declare const setActiveSection: (screenId: string, activeSection: string | typeof WIZARD_FINISHED | null, isInitialLoad?: boolean) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const stepOneSection: (screenId: string, direction: 1 | -1) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
//# sourceMappingURL=common-actions.d.ts.map