import { getStore } from '../../redux';
import { setWidgetOptions } from '../../redux/actions';
import { refreshWidget } from '../../service/dashboard-service';
import { GraphQLMutationApi } from '../../service/graphql-api';
import { BaseDeveloperApi } from '../../service/screen-base';
import { DASHBOARD_SCREEN_ID } from '../../utils/constants';
export var WidgetCacheLifespan;
(function (WidgetCacheLifespan) {
    WidgetCacheLifespan[WidgetCacheLifespan["hour"] = 3600000] = "hour";
    WidgetCacheLifespan[WidgetCacheLifespan["day"] = 86400000] = "day";
    WidgetCacheLifespan[WidgetCacheLifespan["noCache"] = -1] = "noCache";
})(WidgetCacheLifespan || (WidgetCacheLifespan = {}));
export var WidgetType;
(function (WidgetType) {
    WidgetType["barChart"] = "barChart";
    WidgetType["contactCard"] = "contactCard";
    WidgetType["gauge"] = "gauge";
    WidgetType["indicatorTile"] = "indicatorTile";
    WidgetType["indicatorTileGroup"] = "indicatorTileGroup";
    WidgetType["lineChart"] = "lineChart";
    WidgetType["pieChart"] = "pieChart";
    WidgetType["staticContent"] = "staticContent";
    WidgetType["table"] = "table";
    WidgetType["visualProcess"] = "visualProcess";
})(WidgetType || (WidgetType = {}));
export class WidgetDeveloperApi extends BaseDeveloperApi {
    constructor(parentWidget, widgetId, dashboardId, group, _contextVariables) {
        super(DASHBOARD_SCREEN_ID);
        this.parentWidget = parentWidget;
        this.widgetId = widgetId;
        this.dashboardId = dashboardId;
        this.group = group;
        this._contextVariables = _contextVariables;
        this.graph = new GraphQLMutationApi();
    }
    refreshWidget() {
        refreshWidget(this.widgetId, this.group);
    }
    get data() {
        if (this.parentWidget.constructor.prototype.__data) {
            return this.parentWidget.constructor.prototype.__data;
        }
        const state = getStore().getState();
        const widgetDefinition = state.dashboard.dashboardGroups[this.group].widgets[this.widgetId];
        return widgetDefinition?.data || null;
    }
    get contextVariables() {
        return this._contextVariables ? Object.freeze(this._contextVariables) : null;
    }
    get settings() {
        const state = getStore().getState();
        // If the dashboard editor is open, we use the settings from the working copy of the dashboard editor
        const dashboardDefinition = state.dashboard.dashboardGroups[this.group].dashboardEditor.isOpen &&
            state.dashboard.dashboardGroups[this.group].dashboardEditor.currentDashboardDefinition
            ? state.dashboard.dashboardGroups[this.group].dashboardEditor.currentDashboardDefinition
            : state.dashboard.dashboardGroups[this.group].dashboards?.[this.dashboardId];
        const widgetConfiguration = dashboardDefinition?.children?.find(c => String(c._id) === String(this.widgetId));
        return widgetConfiguration?.settings || {};
    }
    get options() {
        const state = getStore().getState();
        const widgetDefinition = state.dashboard.dashboardGroups[this.group].widgets[this.widgetId];
        return widgetDefinition.options || {};
    }
    set options(newOptions) {
        const dashboardId = this.dashboardId;
        const widgetId = this.widgetId;
        const group = this.group;
        getStore().dispatch(setWidgetOptions(dashboardId, widgetId, group, { ...newOptions }));
    }
}
export class AbstractWidget {
    constructor() {
        const widgetId = this.constructor.prototype.__id;
        const dashboardId = this.constructor.prototype.__dashboardId;
        const group = this.constructor.prototype.__group;
        const contextVariables = Object.freeze(this.constructor.prototype.__contextVariables);
        this._$ = new WidgetDeveloperApi(this, widgetId, dashboardId, group, contextVariables);
    }
    get $() {
        return this._$;
    }
}
//# sourceMappingURL=abstract-widget.js.map