import Typography from 'carbon-react/esm/components/typography';
import * as React from 'react';
import { localize } from '../../service/i18n-service';
import { isChart, getPropertyParentNode } from './widget-editor-utils';
import { getGutterSize } from '../../utils/responsive-utils';
import { connect } from 'react-redux';
import { SortConditionEditor } from '@sage/xtrem-ui-components';
import { objectKeys } from '@sage/xtrem-shared';
export function SortingStep({ stepIndex, browserIs, widgetDefinition, onWidgetDefinitionUpdated, nodeNames, }) {
    const value = (widgetDefinition.orderBy || []).reduce((prevValue, v) => {
        prevValue[v.id] = v.order;
        return prevValue;
    }, {});
    const sortableProperties = React.useMemo(() => objectKeys(widgetDefinition.selectedProperties ?? {})
        .filter(key => {
        if (!widgetDefinition.selectedProperties) {
            return false;
        }
        const p = widgetDefinition.selectedProperties[key];
        return (p.data?.canSort &&
            (isChart(widgetDefinition)
                ? widgetDefinition.xAxis?.property.id === p.id ||
                    widgetDefinition.aggregations?.find(a => a.id === p.id)
                : true));
    })
        .reduce((prevValue, key) => {
        if (widgetDefinition.selectedProperties) {
            prevValue[key] = widgetDefinition.selectedProperties[key];
        }
        return prevValue;
    }, {}), [widgetDefinition]);
    const onChange = React.useCallback((newOrder) => {
        onWidgetDefinitionUpdated({
            ...widgetDefinition,
            orderBy: objectKeys(newOrder).map((id) => {
                return {
                    ...sortableProperties[id],
                    order: newOrder[id],
                };
            }),
        });
    }, [onWidgetDefinitionUpdated, sortableProperties, widgetDefinition]);
    const gridGutter = getGutterSize(browserIs);
    const canAddNewLines = React.useMemo(() => {
        return (widgetDefinition.selectedProperties &&
            (widgetDefinition.orderBy || []).length < objectKeys(sortableProperties || {}).length);
    }, [widgetDefinition.orderBy, sortableProperties, widgetDefinition.selectedProperties]);
    if (widgetDefinition.type !== 'TABLE' &&
        widgetDefinition.type !== 'BAR_CHART' &&
        widgetDefinition.type !== 'LINE_CHART') {
        return null;
    }
    return (React.createElement("div", null,
        React.createElement(Typography, { variant: "h2", "data-testid": "e-widget-editor-step-title" }, localize('@sage/xtrem-ui/widget-editor-sorting-step-title', '{{stepIndex}}. Define sorting', {
            stepIndex,
        })),
        React.createElement("div", { className: "e-widget-editor-section" },
            React.createElement(SortConditionEditor, { canAddNewLines: canAddNewLines, gridGutter: gridGutter, localize: localize, properties: sortableProperties, value: value, onChange: onChange, getPropertySubtitle: (property) => getPropertyParentNode({ nodeNames, property, widgetDefinition }) }))));
}
const mapStateToProps = (state, props) => {
    return {
        ...props,
        browserIs: state.browser.is,
    };
};
export const ConnectedSortingStep = connect(mapStateToProps)(SortingStep);
//# sourceMappingURL=sorting-step.js.map