import { FilterTableComponent, GridColumn, GridRow } from '@sage/xtrem-ui-components';
import Typography from 'carbon-react/esm/components/typography';
import * as React from 'react';
import { localize, localizeEnumMember } from '../../service/i18n-service';
import { carbonLocale } from '../../utils/carbon-locale';
import { isEqual } from 'lodash';
export function FilterStep({ stepIndex, widgetDefinition, onWidgetDefinitionUpdated, locale, nodeNames, }) {
    const { selectedProperties } = widgetDefinition;
    const onFilterTableUpdate = React.useCallback((filters = []) => {
        const currentFilters = widgetDefinition.filters || [];
        if (!isEqual(currentFilters, filters)) {
            onWidgetDefinitionUpdated({ ...widgetDefinition, filters });
        }
    }, [onWidgetDefinitionUpdated, widgetDefinition]);
    return (React.createElement("div", null,
        React.createElement(Typography, { variant: "h2", "data-testid": "e-widget-editor-step-title" }, localize('@sage/xtrem-ui/widget-editor-filter-step-title', '{{stepIndex}}. Add your filters', {
            stepIndex,
        })),
        React.createElement("div", { className: "e-widget-editor-section" },
            React.createElement(GridRow, { columns: 8, gutter: 24, margin: 0, verticalMargin: 0 },
                React.createElement(GridColumn, { columnSpan: 8 },
                    React.createElement(FilterTableComponent, { mode: "table", onChange: onFilterTableUpdate, carbonLocale: carbonLocale, locale: locale, localize: localize, localizeEnumMember: localizeEnumMember, node: widgetDefinition.node, nodeNames: nodeNames, selectedProperties: selectedProperties, value: widgetDefinition.filters || [] }))))));
}
//# sourceMappingURL=filters-step.js.map