var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { AbstractWidget } from '../widgets/abstract-widget';
import { table } from '../widgets/table-widget-decorator';
import { getCallToActionsFromWidgetDefinition } from './generic-widget-utils';
import { TableWidgetQueryBuilder } from './table-widget-query-builder';
export const createGenericTableWidgetDefinition = (userWidgetDefinition, dashboardId, widgetId, group, contextVariables, isPreview = false) => {
    const queryBuilder = new TableWidgetQueryBuilder(userWidgetDefinition);
    const callToActions = getCallToActionsFromWidgetDefinition(userWidgetDefinition, queryBuilder.getFilterObject(), isPreview);
    let GenericTableWidget = class GenericTableWidget extends AbstractWidget {
    };
    GenericTableWidget = __decorate([
        table({
            rowDefinition: queryBuilder.rowDefinition,
            title() {
                return userWidgetDefinition.title || '';
            },
            callToActions,
            content() {
                return queryBuilder.getValue(this.$.data);
            },
            getQuery(queryArgs) {
                return queryBuilder.build(queryArgs);
            },
        })
    ], GenericTableWidget);
    GenericTableWidget.prototype.__id = widgetId;
    GenericTableWidget.prototype.__dashboardId = dashboardId;
    GenericTableWidget.prototype.__group = group;
    GenericTableWidget.prototype.__contextVariables = contextVariables;
    return new GenericTableWidget();
};
//# sourceMappingURL=generic-table-widget.js.map