var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { AbstractWidget } from '../widgets/abstract-widget';
import { indicatorTile } from '../widgets/indicator-tile-widget-decorator';
import { getCallToActionsFromWidgetDefinition } from './generic-widget-utils';
import { IndicatorTileWidgetQueryBuilder } from './indicator-tile-widget-query-builder';
export const createGenericIndicatorTileWidgetDefinition = (userWidgetDefinition, dashboardId, widgetId, group, contextVariables, isPreview = false) => {
    const queryBuilder = new IndicatorTileWidgetQueryBuilder(userWidgetDefinition);
    const callToActions = getCallToActionsFromWidgetDefinition(userWidgetDefinition, queryBuilder.getFilterObject(), isPreview);
    let GenericIndicatorTileWidget = class GenericIndicatorTileWidget extends AbstractWidget {
    };
    GenericIndicatorTileWidget = __decorate([
        indicatorTile({
            title() {
                return userWidgetDefinition.title || '';
            },
            subtitle() {
                return userWidgetDefinition.subtitle || '';
            },
            callToActions,
            value() {
                return queryBuilder.getValue(this.$.data);
            },
            getQuery() {
                return queryBuilder.build();
            },
            icon() {
                return userWidgetDefinition.icon || '';
            },
        })
    ], GenericIndicatorTileWidget);
    GenericIndicatorTileWidget.prototype.__id = widgetId;
    GenericIndicatorTileWidget.prototype.__dashboardId = dashboardId;
    GenericIndicatorTileWidget.prototype.__group = group;
    GenericIndicatorTileWidget.prototype.__contextVariables = contextVariables;
    return new GenericIndicatorTileWidget();
};
//# sourceMappingURL=generic-indicator-tile-widget.js.map