import * as React from 'react';
import { localize } from '../service/i18n-service';
import Typography from 'carbon-react/esm/components/typography';
import IconButton from 'carbon-react/esm/components/icon-button';
import Icon from 'carbon-react/esm/components/icon';
import Textbox from 'carbon-react/esm/components/textbox';
export function DashboardTitleEditor({ title, onChange }) {
    const [currentTitle, setCurrentTitle] = React.useState(title);
    const [isEditing, setEditing] = React.useState(false);
    React.useEffect(() => {
        setCurrentTitle(title);
    }, [title]);
    const onKeyDown = React.useCallback((ev) => {
        if (ev.key === 'Enter') {
            onChange(currentTitle);
            setEditing(false);
        }
    }, [onChange, currentTitle]);
    return (React.createElement(Typography, { variant: "h1", mt: 3, mr: 3, ml: 3, mb: 0, fontSize: "24px" },
        !isEditing && (React.createElement("span", { className: "e-dashboard-editor-title", "data-testid": "e-dashboard-editor-title" }, currentTitle)),
        isEditing && (React.createElement(Textbox, { "data-testid": "e-dashboard-editor-title", value: currentTitle, onChange: (ev) => setCurrentTitle(ev.target.value), onKeyDown: onKeyDown, maxLength: 80 })),
        !isEditing && (React.createElement(IconButton, { "data-testid": "e-dashboard-editor-title-edit", onClick: () => setEditing(true), "aria-label": localize('@sage/xtrem-ui/dashboard-editor-edit-title', 'Edit title') },
            React.createElement(Icon, { tooltipMessage: localize('@sage/xtrem-ui/dashboard-editor-edit-title', 'Edit title'), type: "edit" })))));
}
//# sourceMappingURL=dashboard-title-editor.js.map