import * as React from 'react';
import { type Dashboard, type Dict, type Locale } from '@sage/xtrem-shared';
import type { DashboardBreakpoint, DashboardContextVariables, WidgetDefinitionWithLoadingState } from './dashboard-types';
import type { AbstractResponsiveWidget } from '@sage/bms-dashboard';
export interface DashboardEditorDialogExternalProps {
    contextVariables?: DashboardContextVariables;
    group: string;
}
export interface DashboardEditorDialogProps extends DashboardEditorDialogExternalProps {
    canEditDashboards: boolean;
    currentDashboardDefinition: Dashboard;
    dashboardDefinition: Dashboard;
    isDirty: boolean;
    isNavigationPanelOpened: boolean;
    isOpen?: boolean;
    isRedoDisabled: boolean;
    isUndoDisabled: boolean;
    loadingDashboards: boolean;
    locale: Locale;
    onClose: () => void;
    redoDashboardEditor: () => void;
    removeDashboardEditorWidget: (widgetId: string) => void;
    saveDashboardEditorState: () => Promise<void>;
    setNavigationPanelIsOpened: (newState: boolean) => void;
    undoDashboardEditor: () => void;
    updateDashboardEditorWidgetPositions: (widgets: AbstractResponsiveWidget[], breakpoint: DashboardBreakpoint) => void;
    updateDashboardTitleInEditor: (newTitle: string) => void;
    widgets: Dict<WidgetDefinitionWithLoadingState>;
    isMobileEditor: boolean;
}
export declare function DashboardEditorDialog({ canEditDashboards, contextVariables, currentDashboardDefinition, dashboardDefinition, group, isDirty, isNavigationPanelOpened, isOpen, isRedoDisabled, isUndoDisabled, loadingDashboards, locale, onClose, redoDashboardEditor, removeDashboardEditorWidget, saveDashboardEditorState, setNavigationPanelIsOpened, undoDashboardEditor, updateDashboardEditorWidgetPositions, updateDashboardTitleInEditor, widgets, isMobileEditor, }: DashboardEditorDialogProps): React.ReactElement;
export declare const ConnectedDashboardEditorDialog: import("react-redux").ConnectedComponent<typeof DashboardEditorDialog, {
    contextVariables?: DashboardContextVariables | undefined;
    group: string;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
//# sourceMappingURL=dashboard-editor-dialog.d.ts.map