import * as React from 'react';
import { type Dashboard, type Dict, type Locale } from '@sage/xtrem-shared';
import type { OnTelemetryEventFunction } from '../redux/state';
import type { DashboardBreakpoint, DashboardContextVariables, WidgetDefinitionWithLoadingState } from './dashboard-types';
export interface DashboardComponentExternalProps {
    group: string;
    dashboardContextVariables?: DashboardContextVariables;
    hasTabs?: boolean;
}
export interface DashboardComponentProps extends DashboardComponentExternalProps {
    canEditDashboards: boolean;
    cloneDashboard: (dashboardId: string) => Promise<void>;
    dashboardDefinition?: Dashboard;
    deleteDashboard: (dashboardId: string) => Promise<void>;
    fetchUserDashboardDefinition: () => void;
    globalLoading: boolean;
    hasInstalledPackagesLoaded: boolean;
    loadingDashboards: boolean;
    locale: Locale;
    openDashboardEditorDialog: () => void;
    refreshCurrentDashboard: () => void;
    widgets: Dict<WidgetDefinitionWithLoadingState>;
    onTelemetryEvent?: OnTelemetryEventFunction;
}
type DIALOG_MODE_OBJ = {
    CREATE_DASHBOARD: 'CREATE_DASHBOARD';
    EDIT_DASHBOARD: 'EDIT_DASHBOARD';
    NONE: 'NONE';
};
export type DIALOG_MODE = DIALOG_MODE_OBJ[keyof DIALOG_MODE_OBJ];
export interface DashboardComponentState {
    dialogMode: DIALOG_MODE;
    startedFetching: boolean;
    verticalSpaceReady: boolean;
    breakpoint: DashboardBreakpoint;
}
export declare class DashboardComponent extends React.Component<DashboardComponentProps, DashboardComponentState> {
    constructor(props: DashboardComponentProps);
    componentDidMount(): void;
    componentDidUpdate(prevProps: DashboardComponentProps): void;
    private readonly fetchDashboards;
    private readonly onCreateDialogOpen;
    private readonly onCreateDialogClose;
    private readonly onDeleteDashboard;
    private readonly onDuplicateDashboard;
    private readonly renderNoDashboards;
    private readonly renderEmptyDashboard;
    private readonly renderActionButton;
    private readonly renderKebabMenu;
    private readonly getWidgets;
    private readonly onBreakpointChange;
    private readonly renderDashboard;
    render(): React.ReactNode;
}
export declare const ConnectedDashboardComponent: import("react-redux").ConnectedComponent<typeof DashboardComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<DashboardComponent> | undefined;
    group: string;
    dashboardContextVariables?: DashboardContextVariables | undefined;
    hasTabs?: boolean | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export {};
//# sourceMappingURL=dashboard-component.d.ts.map