import * as React from 'react';
import Icon from 'carbon-react/esm/components/icon';
import { AccordionGroup } from 'carbon-react/esm/components/accordion';
import Typography from 'carbon-react/esm/components/typography';
import { ToolEvent } from './tool-event-component';
import { localize } from '../service/i18n-service';
export function CollapsibleToolEvents({ toolEvents }) {
    if (toolEvents.length === 0)
        return null;
    return (React.createElement("div", { className: "e-copilot-tools-container" },
        React.createElement(Typography, { variant: "segment-header", marginBottom: "12px", paddingLeft: "12px" },
            React.createElement(Icon, { type: "spanner", marginRight: "8px" }),
            localize('@sage/xtrem-ui/chatbot-tools', 'Tools')),
        React.createElement(AccordionGroup, null, toolEvents.map((event, index) => (
        // eslint-disable-next-line react/no-array-index-key
        React.createElement(ToolEvent, { key: index, event: event }))))));
}
//# sourceMappingURL=tool-events-component.js.map