import * as React from 'react';
import Loader from 'carbon-react/esm/components/loader';
import Icon from 'carbon-react/esm/components/icon';
import IconButton from 'carbon-react/esm/components/icon-button';
import { localize } from '../service/i18n-service';
import * as tokens from '@sage/design-tokens/js/base/common';
import { Accordion } from 'carbon-react/esm/components/accordion';
import Typography from 'carbon-react/esm/components/typography';
import { copyToClipboard } from '../utils/dom';
export function ToolEvent({ event }) {
    const inputContent = React.useMemo(() => {
        if (event.toolName === 'queryGraphql') {
            return event.input?.query;
        }
        return event.input
            ? typeof event.input === 'string'
                ? event.input
                : JSON.stringify(event.input, null, 2)
            : 'No input data';
    }, [event.input, event.toolName]);
    const outputContent = React.useMemo(() => {
        if (event.toolName === 'queryGraphql' && event.result?.[0]?.text) {
            try {
                return JSON.stringify(JSON.parse(event.result?.[0]?.text).data, null, 2);
            }
            catch (error) {
                // Intentionally left empty.
            }
        }
        if (event.toolName === 'generateLink' && event.result?.[0]?.text) {
            try {
                return event.result?.[0]?.text;
            }
            catch (error) {
                // Intentionally left empty.
            }
        }
        return typeof event.result === 'string' ? event.result : JSON.stringify(event.result, null, 2);
    }, [event.result, event.toolName]);
    const statusIcon = React.useMemo(() => {
        switch (event.status) {
            case 'running':
                return 'in_progress'; // Spinning arrows, will be animated with CSS
            case 'completed':
                return 'tick_circle';
            case 'error':
                return 'cross_circle';
            default:
                return 'none';
        }
    }, [event.status]);
    const statusBorderColor = React.useMemo(() => {
        switch (event.status) {
            case 'running':
                return tokens.colorsSemanticFocus500;
            case 'completed':
                return tokens.colorsSemanticPositive500;
            case 'error':
                return tokens.colorsSemanticNegative500;
            default:
                return tokens.colorsUtilityMajor200;
        }
    }, [event.status]);
    const onCopyInput = React.useCallback(() => {
        copyToClipboard(inputContent);
    }, [inputContent]);
    const onOutputCopy = React.useCallback(() => {
        copyToClipboard(outputContent);
    }, [outputContent]);
    return (React.createElement(Accordion, { size: "small", title: React.createElement(Typography, { variant: "segment-subheader" },
            React.createElement(Icon, { color: statusBorderColor, type: statusIcon, marginRight: "8px" }),
            event.toolName) },
        React.createElement("div", { className: "e-copilot-tool-section" },
            React.createElement("div", { className: "e-copilot-tool-section-header" },
                React.createElement("span", { className: "e-copilot-tool-section-label" },
                    React.createElement(Icon, { type: "import" }),
                    " Input"),
                React.createElement(IconButton, { onClick: onCopyInput },
                    React.createElement(Icon, { tooltipMessage: localize('@sage/xtrem-ui/table-copy', 'Copy'), type: "copy", color: "var(--colorsUtilityMajor400)" }))),
            React.createElement("div", { className: "e-copilot-tool-code-block" },
                React.createElement("pre", { className: "e-copilot-tool-code" }, inputContent))),
        event.result && (React.createElement("div", { className: "e-copilot-tool-section" },
            React.createElement("div", { className: "e-copilot-tool-section-header" },
                React.createElement("span", { className: "e-copilot-tool-section-label" },
                    React.createElement(Icon, { type: "export" }),
                    " Result"),
                React.createElement(IconButton, { onClick: onOutputCopy },
                    React.createElement(Icon, { tooltipMessage: localize('@sage/xtrem-ui/table-copy', 'Copy'), type: "copy", color: "var(--colorsUtilityMajor400)" }))),
            React.createElement("div", { className: "e-copilot-tool-code-block" },
                React.createElement("pre", { className: "e-copilot-tool-code" }, outputContent)))),
        event.status === 'running' && (React.createElement("div", { className: "e-copilot-tool-section" },
            React.createElement("div", { className: "e-copilot-tool-running" },
                React.createElement("div", { className: "e-copilot-tool-spinner" }),
                React.createElement("span", { className: "e-copilot-tool-running-text" },
                    React.createElement(Loader, { variant: "gradient" })))))));
}
ToolEvent.displayName = 'Accordion';
//# sourceMappingURL=tool-event-component.js.map