import type { MessageParam } from '@anthropic-ai/sdk/resources';
export type MessageRole = MessageParam['role'];
export interface ConversationMessage extends MessageParam {
    toolEvents?: ToolEvent[];
    timestamp?: string;
    timeToFirstTokenMs?: number;
    timeToLastTokenMs?: number;
    isStreaming?: boolean;
}
export type Conversation = Array<ConversationMessage>;
export interface ToolEvent {
    type: 'tool_use' | 'tool_result';
    toolName: string;
    input?: any;
    result?: any;
    status: 'running' | 'completed' | 'error';
}
export interface ChatbotUsage {
    percent: number;
    blockedUntil?: string;
}
export interface ChatbotAccess {
    isAllowed: boolean;
    reason?: string;
    usage?: ChatbotUsage;
}
export type StreamEvent = {
    type: 'connected';
} | {
    type: 'thinking';
    message: string;
} | {
    type: 'tool_use';
    toolName: string;
    input: any;
} | {
    type: 'tool_result';
    toolName: string;
    result: any;
    status: 'completed' | 'error';
} | {
    type: 'text_chunk';
    text: string;
} | {
    type: 'completed';
    finalText: string;
    conversationId: string;
    timestamp?: string;
    timeToFirstTokenMs?: number;
    timeToLastTokenMs?: number;
} | {
    type: 'access';
    access: ChatbotAccess;
} | {
    type: 'error';
    error: string;
};
export type StreamEventHandler = (event: StreamEvent) => void;
export interface ConversationHistoryItem {
    messages: ConversationMessage[];
    _createStamp: string;
    id: string;
    title: string;
    isFailed: boolean;
}
export type ConversationHistory = ConversationHistoryItem[];
//# sourceMappingURL=copilot-types.d.ts.map