import type { LocalizeLocale } from '@sage/xtrem-shared';
import type { PageContext } from '../redux/state';
import type { ChatbotAccess, Conversation, ConversationHistory, StreamEventHandler } from './copilot-types';
export declare function fetchConversationHistory(locale: LocalizeLocale, path?: string): Promise<ConversationHistory>;
export declare function fetchConversationStarterQuestions(locale: LocalizeLocale, path?: string): Promise<string[]>;
export declare function fetchConversationAccess(locale: LocalizeLocale, path?: string): Promise<ChatbotAccess>;
export declare function sendTranscribeStreamingRequest({ blob, sampleRate, path, locale, onStreamEvent, }: {
    blob: Blob;
    sampleRate: number;
    path?: string;
    locale?: string;
    onStreamEvent: StreamEventHandler;
}): Promise<void>;
/**
 * Send a copilot message with streaming support using fetch API
 * This provides more control over the streaming process and better browser support
 */
export declare function sendCopilotMessageStreaming(conversation: Conversation, onStreamEvent: StreamEventHandler, locale: LocalizeLocale, conversationId?: string, pageContext?: PageContext | null, abortSignal?: AbortSignal, path?: string): Promise<Conversation>;
/**
 * Simple streaming function that accumulates text chunks and returns the final message
 * Use this when you want streaming but don't need to handle individual events
 */
export declare function sendCopilotMessageStreamingSimple(conversation: Conversation, locale: LocalizeLocale, conversationId?: string, onTextChunk?: (text: string) => void, pageContext?: PageContext | null, abortSignal?: AbortSignal): Promise<Conversation>;
/**
 * Check if streaming is supported in the current environment
 */
export declare function isStreamingSupported(): boolean;
//# sourceMappingURL=copilot-service.d.ts.map