import * as React from 'react';
import { CartesianGrid, Line, XAxis, YAxis, LineChart, Legend, BarChart, Tooltip, Bar, PieChart, Pie, Cell, } from 'recharts';
import { chartColors } from '../component/field/chart/chart-utils';
export function CopilotChart(props) {
    const seriesKeys = Object.keys(props.data[0] || {}).filter(key => key !== props.baseAxis);
    if (props.chartType === 'line') {
        return (React.createElement("div", { className: "e-copilot-chart" },
            React.createElement(LineChart, { data: props.data, height: props.isFullScreen ? 400 : 200, width: props.width || 500 },
                React.createElement(CartesianGrid, { strokeDasharray: "3 3" }),
                seriesKeys.map((key, index) => (React.createElement(Line, { dataKey: key, stroke: chartColors[index % chartColors.length], key: key }))),
                React.createElement(XAxis, { dataKey: props.baseAxis }),
                React.createElement(YAxis, null),
                React.createElement(Tooltip, null),
                React.createElement(Legend, null))));
    }
    if (props.chartType === 'bar') {
        return (React.createElement("div", { className: "e-copilot-chart" },
            React.createElement(BarChart, { data: props.data, height: props.isFullScreen ? 400 : 200, width: props.width || 300 },
                React.createElement(CartesianGrid, { strokeDasharray: "3 3" }),
                React.createElement(XAxis, { dataKey: props.baseAxis }),
                React.createElement(YAxis, null),
                React.createElement(Legend, null),
                React.createElement(Tooltip, null),
                seriesKeys.map((key, index) => (React.createElement(Bar, { dataKey: key, fill: chartColors[index % chartColors.length], key: key }))))));
    }
    if (props.chartType === 'pie') {
        return (React.createElement("div", { className: "e-copilot-chart" },
            React.createElement(PieChart, { height: props.isFullScreen ? 400 : 200, width: props.width || 300 },
                React.createElement(Pie, { data: props.data, dataKey: seriesKeys[0], paddingAngle: 2, label: labelProps => {
                        return `${props.data[labelProps.index][props.baseAxis]}: ${labelProps.value}`;
                    } }, props.data.map((entry, index) => (React.createElement(Cell, { key: `cell-${entry.name}`, fill: chartColors[index % chartColors.length] })))))));
    }
    return null;
}
//# sourceMappingURL=copilot-chart.js.map