import * as React from 'react';
import type { ApplicationContext, Menu, PageContext } from '../integration';
import type { Dict } from '@sage/xtrem-shared';
import type { QueryParameters } from '../utils/types';
import './element-details-logger';
import '../render/style/index.scss';
import './consumer-mock.scss';
export interface PageMetadata {
    key: string;
    title: string;
}
export interface PageEntry {
    name: string;
    pages: PageMetadata[];
}
export interface ConsumerMockState {
    error?: Error;
    isAppDirty: boolean;
    isCopilotOpen: boolean;
    isPlaySoundEnabled: boolean;
    isSitemapVisible: boolean;
    isXtremChatbotAvailable?: boolean;
    locale: string;
    menuItems: Menu[];
    openedModules?: Dict<boolean>;
    openPath: string | null;
    pageContext?: PageContext | null;
    pageSearch: string;
    preNavigationConfirmation: (() => Promise<void>) | null;
    productName: string;
    siteMap: PageEntry[];
    userCode?: string;
    username?: string;
    displayName?: string;
    profilePictureUrl?: string;
}
export declare class ConsumerMock extends React.Component<{}, ConsumerMockState> {
    private readonly containerRef;
    private readonly xtremUiRef;
    constructor(props: any);
    componentDidMount(): void;
    componentDidCatch(error: Error): void;
    initiateSocketConnection: (protocols?: string) => void;
    onInternalNavigate: (path: string, queryParameters?: QueryParameters) => void;
    onMenuChange: (newMenuItems: Menu[]) => void;
    onLocaleChange: (event: React.ChangeEvent<{
        value: string;
    }>) => void;
    onSoundToggleChange: (event: React.ChangeEvent<{
        value: string;
    }>) => void;
    onUserChange: (event: any) => void;
    filterSitemapItems: (page: PageMetadata) => boolean;
    sitemapClick: () => void;
    renderMenuItems: (menuItems: Menu[], isLeft?: boolean) => React.ReactNode;
    openMenuItem: (url: string) => () => Promise<void>;
    onClearTestIds: () => void;
    onToggleCopilot: () => void;
    onToggleClose: () => void;
    onShowTestIds: () => void;
    onPageTitleChange: (newTitle: string | null) => void;
    getApplicationContext: () => ApplicationContext;
    onToggleModuleName: (moduleName: string) => () => void;
    renderNavigation: () => React.ReactNode;
    onPageSearch: (searchText: string) => void;
    isPageInModuleAndOpenModule: (moduleEntry: PageEntry, pageSearch: string) => boolean;
    render(): React.ReactNode;
}
//# sourceMappingURL=consumer-mock.d.ts.map