import * as tokens from '@sage/design-tokens/js/base/common';
import { ActionPopover, ActionPopoverDivider, ActionPopoverItem, ActionPopoverMenu, } from 'carbon-react/esm/components/action-popover';
import Button from 'carbon-react/esm/components/button';
import ButtonMinor from 'carbon-react/esm/components/button-minor';
import Hr from 'carbon-react/esm/components/hr';
import Icon from 'carbon-react/esm/components/icon';
import IconButton from 'carbon-react/esm/components/icon-button';
import { noop } from 'lodash';
import * as React from 'react';
import * as ReactDom from 'react-dom';
import { connect } from 'react-redux';
import { localize } from '../../service/i18n-service';
import { ACTION_POPOVER_SUBMENUS_COMPAT_CSS_CLASS, SINGLE_INLINE_ACTION_CSS_CLASS } from '../../utils/constants';
function XtremMobilePopoverMenuItem({ item, level = 0, onSelect, isDisabled, }) {
    const [isOpen, setOpen] = React.useState(false);
    if (item.isHidden) {
        return null;
    }
    if (item.isMenuSeparator) {
        return React.createElement(Hr, { m: 0, "data-testid": item.testId });
    }
    const props = {
        fullWidth: true,
        buttonType: 'tertiary',
        mt: '8px',
        mb: '8px',
        ml: 0,
        mr: 0,
        iconType: item.icon || 'none',
        'data-testid': item.testId,
        'aria-label': item.title,
        disabled: isDisabled || item.isDisabled,
        destructive: item.isDestructive,
        key: `${level}_${item.key}`,
        className: item.isDestructive
            ? `e-action-popover-item e-action-popover-item-level-${level} e-action-popover-item-destructive`
            : `e-action-popover-item e-action-popover-item-level-${level}`,
    };
    if (item.childrenProp && item.childrenProp.length > 0) {
        return (React.createElement(React.Fragment, null,
            React.createElement(ButtonMinor, { "aria-label": props['aria-label'], buttonType: props.buttonType, className: props.className, "data-testid": props['data-testid'], destructive: props.destructive, disabled: props.disabled, fullWidth: props.fullWidth, iconType: props.iconType, key: props.key, mb: props.mb, ml: props.ml, mr: props.mr, mt: props.mt, onClick: () => setOpen(!isOpen) },
                React.createElement("span", { className: "e-action-popover-item-mobile-label" }, item.title),
                React.createElement(Icon, { type: isOpen ? 'chevron_down' : 'chevron_up' })),
            isOpen &&
                item.childrenProp.map(c => (React.createElement(XtremMobilePopoverMenuItem, { key: `${level}_${item.key}`, item: c, level: level + 1, isDisabled: isDisabled, onSelect: onSelect })))));
    }
    return (React.createElement(ButtonMinor, { "aria-label": props['aria-label'], buttonType: props.buttonType, className: props.className, "data-testid": props['data-testid'], destructive: props.destructive, disabled: props.disabled, fullWidth: props.fullWidth, iconType: props.iconType, key: props.key, mb: props.mb, ml: props.ml, mr: props.mr, mt: props.mt, onClick: onSelect(item) },
        React.createElement("span", { className: "e-action-popover-item-mobile-label" }, item.title)));
}
export function XtremActionPopover({ color, isDeviceLessThanSmall, isDisabled, isOverSidebar, items, noIconSupport, onOpen, pendoId, }) {
    const [isOpen, setIsOpen] = React.useState(false);
    React.useEffect(() => {
        return () => {
            document.body.classList.remove(ACTION_POPOVER_SUBMENUS_COMPAT_CSS_CLASS);
        };
    }, []);
    const getVisibleMenuItemsAndMenuSeparators = React.useCallback(() => {
        return items.filter((item) => !item.isHidden);
    }, [items]);
    const toggleMobileMenu = React.useCallback((event) => {
        event.preventDefault();
        event.stopPropagation();
        if (onOpen) {
            onOpen();
        }
        setIsOpen(o => !o);
    }, [onOpen]);
    const onRecordClick = React.useCallback((item) => (event) => {
        toggleMobileMenu(event);
        if (item.onClick && !isDisabled) {
            item.onClick();
        }
    }, [isDisabled, toggleMobileMenu]);
    const getSingleActionIconButton = React.useCallback((item) => {
        const onClick = (e) => {
            e.preventDefault();
            e.stopPropagation();
            if (item.onClick && !isDisabled) {
                item.onClick();
            }
        };
        return (React.createElement(IconButton, { onClick: onClick, disabled: isDisabled || item.isDisabled, 
            // @ts-expect-error tabIndex not included in the carbon IconButton typings
            tabIndex: isDisabled ? -1 : 0, "aria-label": item.title, "data-testid": SINGLE_INLINE_ACTION_CSS_CLASS, className: SINGLE_INLINE_ACTION_CSS_CLASS },
            React.createElement(Icon, { tooltipMessage: item.title, type: item.icon, color: item.isDestructive ? tokens.colorsSemanticNegative500 : tokens.colorsActionMinor500 })));
    }, [isDisabled]);
    const getMobileActionButton = React.useCallback(() => {
        const visibleItems = getVisibleMenuItemsAndMenuSeparators();
        const hasChildren = (item) => {
            return (!item.isMenuSeparator &&
                !!item.childrenProp &&
                Array.isArray(item.childrenProp) &&
                item.childrenProp.length > 0);
        };
        if (noIconSupport || (visibleItems.length === 1 && hasChildren(visibleItems[0])) || visibleItems.length > 1) {
            return (React.createElement(IconButton, { onClick: toggleMobileMenu, "data-component": "action-popover-button", "data-element": "action-popover-button" },
                React.createElement(Icon, { type: "ellipsis_vertical", color: color })));
        }
        if (visibleItems.length === 1 && !visibleItems[0].isMenuSeparator) {
            return getSingleActionIconButton(visibleItems[0]);
        }
        return null;
    }, [color, getSingleActionIconButton, getVisibleMenuItemsAndMenuSeparators, noIconSupport, toggleMobileMenu]);
    const menuItemReducer = React.useCallback((previousValue, item, index, menuItems) => {
        if (item.isMenuSeparator) {
            if (index === 0) {
                // Do not render menu separator at the beginning of the list
                return previousValue;
            }
            if (menuItems[index - 1].isMenuSeparator) {
                // Do not render repeated menu separators
                return previousValue;
            }
            if (menuItems.slice(index).every(i => i.isMenuSeparator)) {
                // Do not render menu separator at the end of the list
                return previousValue;
            }
            previousValue.push(isDeviceLessThanSmall ? (React.createElement("div", { className: "e-action-popover-divider", key: item.key },
                React.createElement(ActionPopoverDivider, null))) : (React.createElement(ActionPopoverDivider, { key: item.key })));
            return previousValue;
        }
        const actionPopoverProps = {
            icon: item.icon,
            disabled: isDisabled || item.isDisabled,
            onClick: onRecordClick(item),
            children: React.createElement("span", { "data-testid": item.testId }, item.title),
            key: item.key,
            'data-pendoid': item.pendoId,
        };
        if (item.childrenProp && item.childrenProp.length > 0) {
            const submenu = (React.createElement(ActionPopoverMenu, { key: item.key }, item.childrenProp.reduce(menuItemReducer, [])));
            actionPopoverProps.submenu = submenu;
            actionPopoverProps.onClick = noop;
        }
        actionPopoverProps.className = item.isDestructive ? 'e-action-popover-item-destructive' : undefined;
        const actionPopoverItem = React.createElement(ActionPopoverItem, { ...actionPopoverProps });
        previousValue.push(actionPopoverItem);
        return previousValue;
    }, [isDeviceLessThanSmall, isDisabled, onRecordClick]);
    const createActionPopoverChildren = React.useMemo(() => {
        return getVisibleMenuItemsAndMenuSeparators().reduce(menuItemReducer, []);
    }, [getVisibleMenuItemsAndMenuSeparators, menuItemReducer]);
    const createActionPopoverChildrenMobile = React.useCallback(() => {
        return (React.createElement("div", { className: "e-action-popover-item-list-wrapper" }, getVisibleMenuItemsAndMenuSeparators().map((item) => (React.createElement(XtremMobilePopoverMenuItem, { key: item.key, item: item, isDisabled: isDisabled, level: 0, onSelect: onRecordClick })))));
    }, [getVisibleMenuItemsAndMenuSeparators, isDisabled, onRecordClick]);
    const itemHasNoIcon = React.useCallback((item) => {
        return !item.icon || item.icon === 'none';
    }, []);
    const onActionPopoverClose = React.useCallback(() => {
        setIsOpen(false);
    }, []);
    const onActionPopoverOpen = React.useCallback(() => {
        /* This timeout is necessary as the carbon ActionPopover submenus are buggy and flickering in first render */
        document.body.classList.add(ACTION_POPOVER_SUBMENUS_COMPAT_CSS_CLASS);
        setIsOpen(true);
        document.body.classList.remove(ACTION_POPOVER_SUBMENUS_COMPAT_CSS_CLASS);
        onOpen?.();
    }, [onOpen]);
    const renderButton = React.useCallback(() => {
        const message = localize('@sage/xtrem-ui/action-button-more', 'More Actions');
        return (React.createElement(IconButton, { "data-component": "action-popover-button", "data-element": "action-popover-button" },
            React.createElement(Icon, { "aria-label": message, type: "ellipsis_vertical", tooltipMessage: message, color: color })));
    }, [color]);
    const renderDesktop = React.useCallback(() => {
        const message = localize('@sage/xtrem-ui/action-button-more', 'More Actions');
        const visibleItemsAndMenuSeparators = getVisibleMenuItemsAndMenuSeparators();
        const visibleItems = visibleItemsAndMenuSeparators.filter(i => !i.isMenuSeparator);
        if (noIconSupport ||
            (visibleItems.length === 1 && visibleItems[0].childrenProp && visibleItems[0].childrenProp.length > 0) ||
            visibleItems.length > 1 ||
            (visibleItems.length === 1 && itemHasNoIcon(visibleItems[0]))) {
            if (isDisabled) {
                return (React.createElement(Button, { iconType: "ellipsis_vertical", disabled: true, "aria-label": message, buttonType: "tertiary", onClick: noop, "data-testid": "e-popover-open" }));
            }
            return (React.createElement(ActionPopover, { "data-pendoid": pendoId, renderButton: renderButton, onOpen: onActionPopoverOpen, onClose: onActionPopoverClose }, createActionPopoverChildren));
        }
        if (visibleItems.length === 1) {
            return getSingleActionIconButton(visibleItems[0]);
        }
        return null;
    }, [
        createActionPopoverChildren,
        getSingleActionIconButton,
        getVisibleMenuItemsAndMenuSeparators,
        isDisabled,
        itemHasNoIcon,
        noIconSupport,
        onActionPopoverClose,
        onActionPopoverOpen,
        pendoId,
        renderButton,
    ]);
    const renderMobile = React.useCallback(() => {
        const classes = ['e-action-popover-mobile'];
        if (isDeviceLessThanSmall && isOverSidebar) {
            classes.push('e-action-popover-mobile-over-sidebar');
        }
        return (React.createElement(React.Fragment, null,
            isOpen &&
                ReactDom.createPortal(React.createElement("div", { className: classes.join(' ') },
                    React.createElement("div", { className: "e-action-popover-mobile-background", onClick: toggleMobileMenu }),
                    React.createElement("div", { className: "e-action-popover-mobile-content", "data-component": "action-popover" }, createActionPopoverChildrenMobile())), window.document.body),
            React.createElement("div", { className: "e-action-popover-mobile" },
                React.createElement("div", { "data-testid": "e-action-popover-mobile-button", className: "e-action-popover-mobile-button" }, getMobileActionButton()))));
    }, [
        createActionPopoverChildrenMobile,
        getMobileActionButton,
        isDeviceLessThanSmall,
        isOpen,
        isOverSidebar,
        toggleMobileMenu,
    ]);
    if (getVisibleMenuItemsAndMenuSeparators().length === 0) {
        return null;
    }
    if (isDeviceLessThanSmall) {
        return renderMobile();
    }
    return renderDesktop();
}
const mapStateToProps = (state, props) => ({
    ...props,
    isDeviceLessThanSmall: state.browser.lessThan.s,
});
export default connect(mapStateToProps)(XtremActionPopover);
//# sourceMappingURL=xtrem-action-popover.js.map