import * as React from 'react';
import type { HasGenericErrorHandler, HasIcon } from '../field/traits';
import type { TableDropdownActionExternalProps } from './table-shared/table-dropdown-actions/table-dropdown-actions';
export interface XtremActionPopoverItem extends HasIcon, HasGenericErrorHandler<any> {
    childrenProp?: Array<XtremActionPopoverItem>;
    key: string;
    isDestructive?: boolean;
    isDisabled?: boolean;
    isHidden?: boolean;
    isMenuSeparator?: false;
    onClick: () => void;
    pendoId?: string;
    testId?: string;
    title: string;
}
export interface XtremActionPopoverMenuSeparator {
    key: string;
    isHidden?: boolean;
    isMenuSeparator: true;
    pendoId?: string;
    testId?: string;
}
export type XtremActionPopoverItemOrMenuSeparator = XtremActionPopoverItem | XtremActionPopoverMenuSeparator;
export interface XtremActionPopoverExternalProps {
    api?: TableDropdownActionExternalProps['api'];
    color?: string;
    column?: TableDropdownActionExternalProps['column'];
    hasInlineActions?: boolean;
    isDisabled?: boolean;
    isOverSidebar?: boolean;
    items: Array<XtremActionPopoverItemOrMenuSeparator>;
    noIconSupport?: boolean;
    onOpen?: () => void;
    pendoId?: string;
    rowIndex?: TableDropdownActionExternalProps['rowIndex'];
}
export interface XtremActionPopoverProps extends XtremActionPopoverExternalProps {
    isDeviceLessThanSmall: boolean;
}
export declare function XtremActionPopover({ color, isDeviceLessThanSmall, isDisabled, isOverSidebar, items, noIconSupport, onOpen, pendoId, }: XtremActionPopoverProps): React.ReactNode;
declare const _default: import("react-redux").ConnectedComponent<typeof XtremActionPopover, {
    api?: import("@ag-grid-community/core").GridApi<any> | undefined;
    color?: string | undefined;
    column?: import("@ag-grid-community/core").Column<any> | undefined;
    hasInlineActions?: boolean | undefined;
    isDisabled?: boolean | undefined;
    isOverSidebar?: boolean | undefined;
    items: Array<XtremActionPopoverItemOrMenuSeparator>;
    noIconSupport?: boolean | undefined;
    onOpen?: (() => void) | undefined;
    pendoId?: string | undefined;
    rowIndex?: number | null | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default _default;
//# sourceMappingURL=xtrem-action-popover.d.ts.map