import * as React from 'react';
import { Icon } from '../icon/icon-component';
import * as tokens from '@sage/design-tokens/js/base/common';
export function TableTooltip(props) {
    return (React.createElement("div", { style: {
            display: 'flex',
            alignItems: 'center',
            justifyContent: 'center',
            maxWidth: '24px',
            height: '32px',
        } },
        React.createElement(Icon, { ...props, tooltipMessage: React.createElement("span", { className: "e-ui-table-tooltip-content" }, props.content), color: props.color ?? tokens.colorsSemanticNegative500, type: props.type ?? 'error', fontSize: props.fontSize || 'small' })));
}
//# sourceMappingURL=tooltip.js.map