import type { I18nProviderProps } from 'carbon-react/esm/components/i18n-provider';
import React from 'react';
import type { TimeComponentProps } from '../../field/time/time-types';
import type { ToggleState } from './time-types';
export type TimeComponentState = {
    hours: number;
    hoursString: string;
    minutesString: string;
    minutes: number;
    seconds: number;
    toggle: ToggleState;
    value: string | null;
};
export type TimeComponentAction = {
    type: 'CHANGE_HOURS';
    hours: TimeComponentState['hoursString'];
} | {
    type: 'CHANGE_MINUTES';
    minutes: TimeComponentState['minutesString'];
} | {
    type: 'CHANGE_VALUE';
    value?: string;
} | {
    type: 'CHANGE_HAS_AM_PM_TOGGLE';
    hasAmPmToggle: boolean;
} | {
    type: 'BLUR_HOURS';
} | {
    type: 'BLUR_MINUTES';
} | {
    type: 'BLUR_FIELD';
} | {
    type: 'TOGGLE_CHANGE';
    toggle: TimeComponentState['toggle'];
};
type UseTimeHook = {
    componentRef: React.RefObject<HTMLDivElement>;
    dataTestId: string;
    dispatch: React.Dispatch<TimeComponentAction>;
    hasAmPmToggle: boolean;
    hoursRef: React.RefObject<HTMLInputElement>;
    maxHours: number;
    minHours: number;
    minutesRef: React.RefObject<HTMLInputElement>;
    onHoursBlur: NonNullable<React.ComponentProps<'input'>['onBlur']>;
    onHoursChange: NonNullable<React.ComponentProps<'input'>['onChange']>;
    onBlurField: () => void;
    onKeyDown: NonNullable<React.ComponentProps<'input'>['onKeyDown']>;
    onMinutesBlur: NonNullable<React.ComponentProps<'input'>['onBlur']>;
    onMinutesChange: NonNullable<React.ComponentProps<'input'>['onChange']>;
    providerLocale?: I18nProviderProps['locale'];
    state: TimeComponentState;
    toggleChange: (toggle: 'AM' | 'PM') => void;
};
type UseTimeProps = Pick<TimeComponentProps, 'locale' | 'isInFocus' | 'elementId' | 'value'> & {
    onChange?: (v: string | null) => void;
};
export declare function useTime({ locale, isInFocus, elementId, value, onChange }: UseTimeProps): UseTimeHook;
export {};
//# sourceMappingURL=use-time.d.ts.map