import type { TimeComponentState } from './use-time';
export declare const TIME_REGEX: RegExp;
export declare function formatString(value: string): string;
export declare function validateHours({ hours, toggle, hasAmPmToggle, }: {
    hours: TimeComponentState['hoursString'];
    toggle: TimeComponentState['toggle'] | 'unknown';
    hasAmPmToggle: boolean;
}): {
    isValid: true;
    hours: TimeComponentState['hours'];
    hoursString: TimeComponentState['hoursString'];
} | {
    isValid: false;
    hoursString: TimeComponentState['hoursString'];
};
export declare function validateMinutes(minutes: TimeComponentState['minutesString']): {
    isValid: true;
    minutes: TimeComponentState['minutes'];
    minutesString: TimeComponentState['minutesString'];
} | {
    isValid: false;
    minutesString: TimeComponentState['minutesString'];
};
export declare function validateSeconds(seconds: string): {
    isValid: true;
    seconds: TimeComponentState['seconds'];
} | {
    isValid: false;
};
export declare function getValueFromString({ time, hasAmPmToggle }: {
    time?: string | null;
    hasAmPmToggle: boolean;
}): {
    hours: number;
    hoursString: string;
    minutes: number;
    minutesString: string;
    seconds: number;
    toggle: TimeComponentState['toggle'];
    value: string | null;
};
//# sourceMappingURL=time-utils.d.ts.map