import React from 'react';
import type { GridRowActionType } from '../../types';
import type { TableDropdownActionsCellProps } from './cell/table-dropdown-action-cell';
import type { InlineCollectionItemAction } from './table-dropdown-actions/table-dropdown-action-types';
interface ResolvedInlineCollectionItemAction extends Omit<InlineCollectionItemAction<any, any>, 'isDisabled' | 'isHidden' | 'isDisplayed' | 'onClick'> {
    isDisabled?: boolean;
    isDisplayed?: boolean;
    isHidden?: boolean;
    key: string;
    onClick?: () => void;
}
interface TableInlineActionsProps {
    inlineActions: Array<ResolvedInlineCollectionItemAction>;
    column?: TableDropdownActionsCellProps['column'];
    api?: TableDropdownActionsCellProps['api'];
    rowIndex?: TableDropdownActionsCellProps['node']['rowIndex'];
    hasDropdownActions?: boolean;
    elementId: string;
    level: number;
}
declare function TableInlineActions({ inlineActions }: TableInlineActionsProps): React.ReactElement;
declare const _default: import("react-redux").ConnectedComponent<typeof TableInlineActions, {
    isDisabled?: boolean | undefined;
    screenId: string;
    level: number;
    onTelemetryEvent?: import("../../../redux/state").OnTelemetryEventFunction | undefined;
    recordId: import("../../../types").NestedRecordId;
    rowValue: any;
    fieldId: string;
    isPhantomRow?: boolean | undefined;
    rowIndex?: TableDropdownActionsCellProps["node"]["rowIndex"] | undefined;
    api?: TableDropdownActionsCellProps["api"] | undefined;
    column?: TableDropdownActionsCellProps["column"] | undefined;
    hasDropdownActions?: boolean | undefined;
    hasInlineActions?: boolean | undefined;
    actions?: GridRowActionType | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default _default;
//# sourceMappingURL=table-inline-actions.d.ts.map