import * as React from 'react';
import type { OnTelemetryEventFunction } from '../../../../redux/state';
import type { CollectionValue } from '../../../../service/collection-data-service';
import type { AccessBindings } from '../../../../service/page-definition';
import type { NestedRecordId } from '../../../../types';
import type { GridRowActionOrMenuSeparatorType } from '../../../types';
import type { TableDropdownActionsCellProps } from '../cell/table-dropdown-action-cell';
import type { CollectionPropertiesWithActions } from './table-dropdown-action-types';
export interface TableDropdownActionExternalProps {
    actions?: GridRowActionOrMenuSeparatorType;
    api?: TableDropdownActionsCellProps['api'];
    column?: TableDropdownActionsCellProps['column'];
    fieldId: string;
    hasDropdownActions?: boolean;
    hasInlineActions?: boolean;
    isDisabled?: boolean;
    isPhantomRow?: boolean;
    level: number;
    onTelemetryEvent?: OnTelemetryEventFunction;
    recordId: NestedRecordId;
    rowIndex?: TableDropdownActionsCellProps['node']['rowIndex'];
    rowValue: any;
    screenId: string;
}
export interface TableDropdownActionProps extends TableDropdownActionExternalProps {
    fieldProperties: CollectionPropertiesWithActions;
    tableData: CollectionValue;
    accessBindings: AccessBindings;
    rowValue: any;
}
export declare function TableDropdownActions({ accessBindings, api, column, fieldId, fieldProperties, hasInlineActions, isDisabled, isPhantomRow, level, recordId, rowIndex, rowValue, screenId, tableData, onTelemetryEvent, }: TableDropdownActionProps): React.ReactNode;
declare const _default: import("react-redux").ConnectedComponent<typeof TableDropdownActions, {
    actions?: GridRowActionOrMenuSeparatorType | undefined;
    api?: TableDropdownActionsCellProps["api"] | undefined;
    column?: TableDropdownActionsCellProps["column"] | undefined;
    fieldId: string;
    hasDropdownActions?: boolean | undefined;
    hasInlineActions?: boolean | undefined;
    isDisabled?: boolean | undefined;
    isPhantomRow?: boolean | undefined;
    level: number;
    onTelemetryEvent?: OnTelemetryEventFunction | undefined;
    recordId: NestedRecordId;
    rowIndex?: TableDropdownActionsCellProps["node"]["rowIndex"] | undefined;
    rowValue: any;
    screenId: string;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default _default;
//# sourceMappingURL=table-dropdown-actions.d.ts.map