import Icon from 'carbon-react/esm/components/icon';
import MultiActionButton from 'carbon-react/esm/components/multi-action-button';
import SplitButton from 'carbon-react/esm/components/split-button';
import React from 'react';
import { localize } from '../../../../service/i18n-service';
import { resolveByValue } from '../../../../utils/resolve-value-utils';
import { ConnectedBusinessAction } from '../../../container/footer/business-action';
import { useSelector } from 'react-redux';
import { getElementAccessStatus } from '../../../../utils/access-utils';
import { getPageDefinitionFromState, getPagePropertiesFromState } from '../../../../utils/state-utils';
export const TableCreateActions = React.memo(({ createActions, multiActionType, screenId, elementId }) => {
    const resolvedCreateActions = useSelector(state => {
        const result = resolveByValue({
            propertyValue: createActions,
            screenId,
            rowValue: null,
            fieldValue: null,
            skipHexFormat: true,
            state,
        });
        if (!result) {
            return [];
        }
        return Array.isArray(result) ? result.filter(action => !!action) : [result];
    });
    const filteredActions = useSelector(state => {
        const screenDefinition = getPageDefinitionFromState(screenId, state);
        const pageProperties = getPagePropertiesFromState(screenId, state);
        const pageAccessNode = String(pageProperties?.access?.node || pageProperties?.node || '');
        return resolvedCreateActions.filter(action => {
            const actionProperties = screenDefinition.metadata.uiComponentProperties[action.id] || {};
            const accessRule = getElementAccessStatus({
                accessBindings: screenDefinition.accessBindings,
                bind: action.id,
                elementProperties: actionProperties,
                contextNode: pageAccessNode,
                dataTypes: state.dataTypes,
                nodeTypes: state.nodeTypes,
            });
            return !accessRule || accessRule === 'authorized';
        });
    });
    const isMultiCreateAction = () => filteredActions.length > 1;
    const isSingleCreateAction = () => filteredActions.length === 1;
    /**
     * INFO: Carbon's SplitButton accepts an Icon component as it's text prop, but is not typed
     *       accordingly. This function is merely to trick TypeScript ;).
     */
    const getAddIconAsString = () => {
        return (React.createElement(Icon, { type: "add" }));
    };
    if (isMultiCreateAction() && multiActionType === 'multi-action-button') {
        const actions = filteredActions;
        return (React.createElement(MultiActionButton, { "data-testid": "e-create-multi-action-button", mr: "16px", text: localize('@sage/xtrem-ui/table-create', 'Create') }, actions.map(action => (React.createElement(ConnectedBusinessAction, { id: action.id, defaultButtonType: "tertiary", isSeparated: false, key: action.id, screenId: screenId, skipWrapping: true, pendoId: `createAction-${screenId}-${elementId}-${action.id}` })))));
    }
    if (isMultiCreateAction() && multiActionType === 'split-button') {
        const actions = filteredActions;
        return (React.createElement(SplitButton, { buttonType: "secondary", "data-testid": "e-create-split-button", size: "small", text: getAddIconAsString() }, actions.map(action => (React.createElement(ConnectedBusinessAction, { id: action.id, defaultButtonType: "tertiary", isSeparated: false, key: action.id, screenId: screenId, skipWrapping: true, pendoId: `createSplitAction-${screenId}-${elementId}` })))));
    }
    if (isSingleCreateAction() && multiActionType === 'multi-action-button') {
        const action = filteredActions[0];
        return (React.createElement(ConnectedBusinessAction, { id: action.id, defaultButtonType: "tertiary", isSeparated: true, key: action.id, screenId: screenId, pendoId: `createAction-${screenId}-${elementId}` }));
    }
    // INFO: Create action when rendered in split navigation view.
    if (isSingleCreateAction() && multiActionType === 'split-button') {
        const action = filteredActions[0];
        return (React.createElement(ConnectedBusinessAction, { id: action.id, buttonTypeOverride: "secondary", isIconOnly: true, isSeparated: true, key: action.id, screenId: screenId, size: "small", pendoId: `createAction-${screenId}-${elementId}` }));
    }
    return null;
});
TableCreateActions.displayName = 'TableCreateActions';
//# sourceMappingURL=table-create-actions.js.map