import * as React from 'react';
import type { AgGridColumnConfigWithScreenIdAndColDef } from '../../../../../utils/ag-grid/ag-grid-utility-types';
type FilterModel = {
    filterType: string;
    values: string[];
    /**
     * By default, the filtering applied to the value field text value, so we need to pass this flag to indicate that
     * the records should be filtered by their ID values
     *  */
    filterById: boolean;
    displayValues: string[];
};
export interface ReferenceFilterProps {
    colDef: AgGridColumnConfigWithScreenIdAndColDef;
    onModelChange: (model: FilterModel | null) => void;
    model?: FilterModel | null;
}
/**
 * Custom filter component for AG-Grid, handling references.
 *
 * Not implemented:
 * - Support for nested grids
 * - "Select All" functionality
 */
export declare function ReferenceFilter({ colDef, onModelChange, model }: ReferenceFilterProps): React.ReactNode;
export declare namespace ReferenceFilter {
    var displayName: string;
}
export default ReferenceFilter;
//# sourceMappingURL=reference-filter.d.ts.map