import localeText from '../../../../utils/ag-grid/ag-grid-strings';
import { Select } from '../../select/select-component';
import React from 'react';
import { EQUALS, GREATER_THAN, GREATER_THAN_EQUAL, LESS_THAN, LESS_THAN_EQUAL, NOT_EQUALS, RANGE, } from '@sage/xtrem-shared';
import { memoize } from 'lodash';
export const filterOptions = memoize(locale => [
    { id: EQUALS, value: EQUALS, displayedAs: locale.equals },
    { id: NOT_EQUALS, value: NOT_EQUALS, displayedAs: locale.notEqual },
    { id: LESS_THAN, value: LESS_THAN, displayedAs: locale.lessThan },
    { id: GREATER_THAN, value: GREATER_THAN, displayedAs: locale.greaterThan },
    { id: LESS_THAN_EQUAL, value: LESS_THAN_EQUAL, displayedAs: locale.lessThanOrEqual },
    { id: GREATER_THAN_EQUAL, value: GREATER_THAN_EQUAL, displayedAs: locale.greaterThanOrEqual },
    { id: RANGE, value: RANGE, displayedAs: locale.inRange },
]);
/**
 * Component that shows a selector with the options to filter by
 */
export function FilterTypeSelect({ value, onChange, options: controlledOptions }) {
    const tableLocaleText = localeText();
    const options = React.useMemo(() => controlledOptions ?? filterOptions(tableLocaleText), [controlledOptions, tableLocaleText]);
    const getItems = React.useMemo(() => async () => options, [options]);
    const selectedItem = React.useMemo(() => options.find(option => option.id === value), [options, value]);
    return (React.createElement(Select, { disableOpenOnFocus: true, hasInputSearch: false, getItems: getItems, onChange: onChange, selectedItem: selectedItem, size: "small", testId: "e-ui-filter-type" }));
}
//# sourceMappingURL=filter-type-select-component.js.map