import { type DateRangeType } from '@sage/xtrem-date-time';
import { type LocalizeLocale } from '@sage/xtrem-shared';
import type { DateFilterState, DateModel, DateState, SimpleDateModel } from './date-filter-types';
export declare const isSimpleDateFilter: (filter: DateModel) => filter is SimpleDateModel;
export declare const agGridDateFilterTypes: string[];
export declare const defaultDateState: () => DateState;
export declare const dateRanges: DateRangeType[];
export declare const getModelFromDateState: ({ dateState, locale, isDatetime, }: {
    dateState: DateFilterState;
    locale: LocalizeLocale;
    isDatetime?: boolean;
}) => SimpleDateModel;
export declare function getDateStateFromModel(model: DateModel | null): DateState;
/**
 * Determines if a model change should be triggered based on the filter state.
 * Prevents premature triggering for range filters that don't have both values set.
 */
export declare const shouldTriggerModelChange: (newValue: Partial<DateFilterState>, updatedState: DateFilterState) => boolean;
//# sourceMappingURL=date-filter-utils.d.ts.map