import Label from 'carbon-react/esm/__internal__/label';
import ButtonBar from 'carbon-react/esm/components/button-bar';
import ButtonMinor from 'carbon-react/esm/components/button-minor';
import ButtonToggleGroup from 'carbon-react/esm/components/button-toggle/button-toggle-group';
import ButtonToggle from 'carbon-react/esm/components/button-toggle/button-toggle.component';
import * as React from 'react';
import { useDispatch } from 'react-redux';
import { refreshNavigationPanel } from '../../../redux/actions';
import { localize } from '../../../service/i18n-service';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { navigationPanelId } from '../../container/navigation-panel/navigation-panel-types';
import { getFieldTitle } from '../../field/carbon-helpers';
import FieldActions from '../../field/field-actions-component';
import { CalendarViewSelector } from '../calendar-body/calendar-view-selector';
import { FiltersComponent } from '../filter/filters-component';
import StatusIconWithPopover from '../icon/status-icon-with-popover';
import { ConnectedNestedFieldErrors } from '../nested-field-errors-component';
import { DesktopTableAddNewRowButton } from './desktop-table-add-new-row-button';
import { TableCreateActions } from './table-create-actions/table-create-actions';
import { ConnectedTableOptionsMenu } from './table-options-menu';
import { TableSearchBox } from './table-search-box-component';
import ConnectedBusinessAction from '../../container/footer/business-action';
import { DesktopTableExportButton } from './desktop-table-export-button';
import { DesktopTablePrintButton } from './desktop-table-print-button';
import { TableViewSelector } from './table-view-selector';
import { getNestedFieldsFromProperties } from '../../../utils/nested-field-utils';
import { useDeepEqualSelector } from '../../../utils/hooks/use-deep-equal-selector';
/**
 * This component contains the header functionality for the desktop table and nested grids. The functionality of these two components is very similar.
 * It contains the field action buttons, export button, business header actions, options menu, validation errors and the field title label.
 */
export const DesktopTableHeaderComponent = React.memo(({ canAddNewLine, columnPanelDisabled, elementId, fieldProperties, filterComponentFields, filtersComponentFilters, filterText, hasAddItemsButton, hasCalendarView, hasData, hasFloatingFilters, hasSidebar, isDisabled, isExportDisabled, isReadOnly, level, onExport, onFilterByErrors, onFiltersComponentChanged, onFocusPhantomRow, onOpenColumnPanel, onOptionsMenuItemChange, onSearchBoxValueChange, onSwitchCalendarView, onSwitchView, onTelemetryEvent, onToggleFilters, onUnsetFilterByErrors, screenId, selectedCalendarView, selectedOptionsMenuItem, tableViewMode, validationErrors, }) => {
    const dispatch = useDispatch();
    const optionsMenu = React.useMemo(() => resolveByValue({
        propertyValue: fieldProperties.optionsMenu,
        rowValue: null,
        screenId,
        fieldValue: null,
        skipHexFormat: true,
    }) || [], [fieldProperties.optionsMenu, screenId]);
    const onRefreshMainList = React.useCallback(() => {
        dispatch(refreshNavigationPanel(screenId));
    }, [dispatch, screenId]);
    const { clientUserSettingsListPage, clientUserSettingsEditPage } = useDeepEqualSelector(state => ({
        clientUserSettingsListPage: state.clientUserSettingsListPage,
        clientUserSettingsEditPage: state.clientUserSettingsEditPage,
    }));
    const hasTableViewSelector = React.useMemo(() => {
        return elementId === navigationPanelId && clientUserSettingsListPage && clientUserSettingsEditPage;
    }, [clientUserSettingsEditPage, clientUserSettingsListPage, elementId]);
    const headerBusinessActions = React.useMemo(() => resolveByValue({
        propertyValue: fieldProperties.headerBusinessActions,
        rowValue: null,
        screenId,
        fieldValue: null,
        skipHexFormat: true,
    }) || [], [fieldProperties.headerBusinessActions, screenId]);
    const hasHeaderBusinessActions = () => {
        if (headerBusinessActions === undefined) {
            return false;
        }
        if (Array.isArray(headerBusinessActions) && headerBusinessActions.length === 0) {
            return false;
        }
        return true;
    };
    const fieldActions = React.useMemo(() => resolveByValue({
        propertyValue: fieldProperties.fieldActions,
        rowValue: null,
        screenId,
        fieldValue: null,
        skipHexFormat: true,
    }) || [], [fieldProperties.fieldActions, screenId]);
    const getOptionsMenuType = () => {
        if (!fieldProperties.optionsMenu?.length) {
            return undefined;
        }
        return fieldProperties.optionsMenuType;
    };
    const renderSearchBox = () => {
        if (onSearchBoxValueChange && fieldProperties.hasSearchBoxMobile) {
            return (React.createElement(TableSearchBox, { elementId: elementId, fieldProperties: fieldProperties, filterText: filterText, isDisabled: isDisabled, onSearchBoxValueChange: onSearchBoxValueChange, screenId: screenId }));
        }
        return React.createElement("div", { className: "e-table-field-mobile-search" });
    };
    const renderViewSelector = () => {
        if (!hasCalendarView || !onSwitchView || isDisabled) {
            return null;
        }
        const value = tableViewMode || 'table';
        return (React.createElement(ButtonToggleGroup, { id: `table-view-selector-${screenId}-${elementId}`, value: value, onChange: (_evt, selectedView) => onSwitchView(selectedView), mr: "8px", ml: "2px" },
            React.createElement(ButtonToggle, { value: "table", buttonIcon: "csv", "aria-label": localize('@sage/xtrem-ui/table-table-view', 'Switch to table view') }),
            React.createElement(ButtonToggle, { value: "calendar", buttonIcon: "calendar", "aria-label": localize('@sage/xtrem-ui/table-calendar-view', 'Switch to calendar view') })));
    };
    const renderHeaderActions = () => {
        const filterButtonMessage = hasFloatingFilters
            ? localize('@sage/xtrem-ui/hide-floating-filters', 'Hide Table Filters')
            : localize('@sage/xtrem-ui/show-floating-filters', 'Show Table Filters');
        const refreshButtonMessage = localize('@sage/xtrem-ui/main-list-refresh', 'Refresh');
        const openColumnPanelMessage = localize('@sage/xtrem-ui/table-open-column-panel', 'Open column panel');
        return (React.createElement("div", { className: "e-field-actions-wrapper" },
            hasAddItemsButton && (React.createElement(DesktopTableAddNewRowButton, { canAddNewLine: canAddNewLine, cardDefinition: fieldProperties.mobileCard, columns: getNestedFieldsFromProperties(fieldProperties), elementId: elementId, hasSidebar: hasSidebar, isDisabled: isDisabled || isReadOnly, level: level, screenId: screenId, sidebarDefinition: fieldProperties.sidebar ||
                    fieldProperties.levels?.[0]?.sidebar })),
            elementId === navigationPanelId
                ? hasHeaderBusinessActions() && (
                // eslint-disable-next-line react/jsx-indent
                React.createElement(TableCreateActions, { createActions: fieldProperties.headerBusinessActions, multiActionType: "multi-action-button", screenId: screenId, elementId: elementId }))
                : headerBusinessActions &&
                    Array.isArray(headerBusinessActions) &&
                    headerBusinessActions.map(hba => (React.createElement(ConnectedBusinessAction, { id: hba.id, defaultButtonType: "tertiary", isSeparated: true, key: hba.id, screenId: screenId }))),
            (!tableViewMode || tableViewMode === 'table') && (React.createElement(DesktopTablePrintButton, { screenId: screenId, elementId: elementId })),
            fieldProperties.canExport &&
                (!tableViewMode || tableViewMode === 'table') &&
                onExport && (React.createElement(DesktopTableExportButton, { screenId: screenId, elementId: elementId, hasData: !!hasData, isDisabled: isDisabled || !!isExportDisabled, onExport: onExport })),
            hasCalendarView && onSwitchCalendarView && tableViewMode === 'calendar' && (React.createElement(CalendarViewSelector, { onSelectView: onSwitchCalendarView, selectedView: selectedCalendarView || 'dayGridMonth' })),
            React.createElement("div", { className: "e-table-field-button-bar-container" },
                React.createElement(ButtonBar, null,
                    elementId === navigationPanelId && (React.createElement(ButtonMinor, { buttonType: "tertiary", disabled: isDisabled, onClick: onRefreshMainList, iconType: "refresh", iconTooltipMessage: refreshButtonMessage, "aria-label": refreshButtonMessage, "data-pendoid": `refreshTable-${elementId}` })),
                    React.createElement(FieldActions, { screenId: screenId, fieldId: elementId, isDisabled: isDisabled, additionalFieldActions: fieldProperties.additionalFieldActions }),
                    onToggleFilters && (!tableViewMode || tableViewMode === 'table') && (React.createElement(ButtonMinor, { buttonType: "tertiary", disabled: isDisabled, onClick: onToggleFilters, iconType: "filter", iconTooltipMessage: filterButtonMessage, "aria-label": filterButtonMessage, "data-pendoid": `tableQuickFilters-${elementId}-${hasFloatingFilters ? 'close' : 'open'}` })),
                    onOpenColumnPanel && (!tableViewMode || tableViewMode === 'table') && (React.createElement(ButtonMinor, { buttonType: "tertiary", disabled: isDisabled || columnPanelDisabled, onClick: onOpenColumnPanel, iconType: "settings", iconTooltipMessage: openColumnPanelMessage, "aria-label": openColumnPanelMessage, "data-pendoid": `openTableColumnPanel-${elementId}` })),
                    onFiltersComponentChanged && filterComponentFields && filtersComponentFilters && (React.createElement(FiltersComponent, { screenId: screenId, fields: filterComponentFields, handleSave: onFiltersComponentChanged, filters: filtersComponentFilters, isDisabled: isDisabled }))))));
    };
    const tableTitle = getFieldTitle(screenId, fieldProperties, null);
    const needsTitleLine = (tableTitle && !fieldProperties.isTitleHidden) ||
        validationErrors.length > 0 ||
        fieldProperties.warningMessage ||
        fieldProperties.infoMessage;
    const renderFieldTitle = () => {
        if (!needsTitleLine) {
            return null;
        }
        return (React.createElement("div", { className: "e-field-title e-table-field-title" },
            React.createElement(Label, { htmlFor: undefined }, tableTitle),
            React.createElement(StatusIconWithPopover, { screenId: screenId, validationErrors: validationErrors, content: React.createElement(ConnectedNestedFieldErrors, { screenId: screenId, elementId: elementId }), filterErrors: onFilterByErrors, unFilterErrors: onUnsetFilterByErrors, warningMessage: fieldProperties.warningMessage, infoMessage: fieldProperties.infoMessage })));
    };
    const renderOptionsMenu = () => {
        if (onOptionsMenuItemChange) {
            return (React.createElement(ConnectedTableOptionsMenu, { elementId: elementId, onSelectionChange: onOptionsMenuItemChange, optionsMenuItems: optionsMenu, optionsMenuType: fieldProperties.optionsMenuType, screenId: screenId, selectedOptionsMenuItem: selectedOptionsMenuItem, onTelemetryEvent: onTelemetryEvent }));
        }
        return null;
    };
    // If none of the header functionality is used, the component is not rendered
    if (!needsTitleLine &&
        optionsMenu.length === 0 &&
        !hasHeaderBusinessActions() &&
        fieldActions.length === 0 &&
        !fieldProperties.canExport &&
        !onExport &&
        !fieldProperties.hasSearchBoxMobile) {
        return null;
    }
    // If we have an options menu than the title displayed above the header line.
    if (optionsMenu.length !== 0) {
        return (React.createElement("div", { className: "e-field-header-wrapper" },
            React.createElement("div", { className: "e-field-title-wrapper" }, renderFieldTitle()),
            React.createElement("div", { className: "e-field-header", "data-options-menu-type": getOptionsMenuType() },
                renderViewSelector(),
                fieldProperties.optionsMenuType !== 'tabs' && onOptionsMenuItemChange && renderOptionsMenu(),
                hasTableViewSelector && React.createElement(TableViewSelector, { screenId: screenId, elementId: elementId }),
                React.createElement("div", { className: "e-field-mobile-search-and-actions" },
                    renderSearchBox(),
                    renderHeaderActions()),
                fieldProperties.optionsMenuType === 'tabs' && renderOptionsMenu())));
    }
    return (React.createElement("div", { className: "e-field-header-wrapper" },
        React.createElement("div", { className: "e-field-header" },
            renderFieldTitle(),
            hasTableViewSelector && React.createElement(TableViewSelector, { screenId: screenId, elementId: elementId }),
            React.createElement("div", { className: "e-field-mobile-search-and-actions" },
                renderSearchBox(),
                renderHeaderActions()))));
});
DesktopTableHeaderComponent.displayName = 'DesktopTableHeaderComponent';
//# sourceMappingURL=desktop-table-header.js.map