import * as React from 'react';
import type { Filter } from '../../../service/filter-service';
import type { ValidationResult } from '../../../service/screen-base-definition';
import type { OptionsMenuItem } from '../../container/page/page-types';
import type { InternalNestedGridProperties } from '../../field/nested-grid/nested-grid-control-object';
import type { InternalTableProperties, TableViewMode } from '../../field/table/table-component-types';
import type { CalendarView } from '../calendar-body/calendar-body-types';
import type { FilterManagerField } from '../filter/filter-manager';
import type { OnTelemetryEventFunction } from '../../../redux/state';
export interface DesktopTableHeaderProps {
    canAddNewLine: boolean;
    columnPanelDisabled?: boolean;
    elementId: string;
    fieldProperties: InternalTableProperties | InternalNestedGridProperties;
    filterComponentFields?: FilterManagerField[];
    filtersComponentFilters?: Filter[];
    filterText?: string;
    hasAddItemsButton: boolean;
    hasCalendarView?: boolean;
    hasData?: boolean;
    hasFloatingFilters?: boolean;
    hasSearchBox?: boolean;
    hasSidebar: boolean;
    isDisabled: boolean;
    isExportDisabled?: boolean;
    isReadOnly: boolean;
    level?: number;
    onExport?: (target: 'csv' | 'excel') => void;
    onFilterByErrors?: () => void;
    onFiltersComponentChanged?: (filters: Filter[]) => Promise<void>;
    onFocusPhantomRow?: () => void;
    /** Callback that is called when the column settings button is clicked. If undefined, the column settings button is not rendered. */
    onOpenColumnPanel?: () => void;
    onOptionsMenuItemChange?: (newOptionItem: OptionsMenuItem) => void;
    onSearchBoxValueChange?: (textValue: string) => void;
    onSwitchCalendarView?: (calendarView: CalendarView) => void;
    onSwitchView?: (view: TableViewMode) => void;
    onTelemetryEvent?: OnTelemetryEventFunction;
    /** Callback that is called when the toggle filter button is clicked. If undefined, the toggle button is not rendered. */
    onToggleFilters?: () => void;
    onUnsetFilterByErrors?: () => void;
    screenId: string;
    selectedCalendarView?: CalendarView;
    selectedOptionsMenuItem?: OptionsMenuItem;
    tableViewMode?: TableViewMode;
    validationErrors: ValidationResult[];
}
/**
 * This component contains the header functionality for the desktop table and nested grids. The functionality of these two components is very similar.
 * It contains the field action buttons, export button, business header actions, options menu, validation errors and the field title label.
 */
export declare const DesktopTableHeaderComponent: React.FC<DesktopTableHeaderProps>;
//# sourceMappingURL=desktop-table-header.d.ts.map