import Button from 'carbon-react/esm/components/button';
import MultiActionButton from 'carbon-react/esm/components/multi-action-button';
import * as React from 'react';
import { localize } from '../../../service/i18n-service';
export function DesktopTableExportButton({ onExport, isDisabled, hasData, elementId, screenId, }) {
    const isButtonDisabled = isDisabled || !hasData;
    return (React.createElement(MultiActionButton, { text: localize('@sage/xtrem-ui/table-export', 'Export'), mr: "16px", "data-testid": "e-table-export", disabled: isDisabled },
        React.createElement(Button, { key: "excel", disabled: isButtonDisabled, onClick: () => onExport('excel'), "data-testid": "e-table-export-excel", "data-pendoid": `exportButton-excel-${screenId}-${elementId}` }, localize('@sage/xtrem-ui/export-format-excel', 'Excel')),
        React.createElement(Button, { key: "csv", disabled: isButtonDisabled, "data-testid": "e-table-export-csv", onClick: () => onExport('csv'), "data-pendoid": `exportButton-csv-${screenId}-${elementId}` }, localize('@sage/xtrem-ui/export-format-csv', 'CSV'))));
}
//# sourceMappingURL=desktop-table-export-button.js.map