import Button from 'carbon-react/esm/components/button';
import MultiActionButton from 'carbon-react/esm/components/multi-action-button';
import { camelCase } from 'lodash';
import * as React from 'react';
import { useDispatch, useSelector } from 'react-redux';
import * as xtremRedux from '../../../redux';
import { localize } from '../../../service/i18n-service';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import BusinessAction from '../../container/footer/business-action';
export const DesktopTableAddNewRowButton = React.memo(({ canAddNewLine, cardDefinition, columns, elementId, hasSidebar, isDisabled, level, screenId, sidebarDefinition, }) => {
    const dispatch = useDispatch();
    const visibleAddItemActions = useSelector((state) => {
        const fieldProperties = state.screenDefinitions[screenId]?.metadata.uiComponentProperties?.[elementId];
        const actions = resolveByValue({
            propertyValue: fieldProperties.addItemActions,
            rowValue: null,
            screenId,
            fieldValue: null,
            skipHexFormat: true,
            state,
        }) ?? [];
        return actions.filter(action => !action.isHidden);
    });
    const onOpenSidebarClick = React.useCallback(() => {
        dispatch(xtremRedux.actions.openTableSidebar({
            cardDefinition,
            columns,
            elementId,
            level,
            screenId,
            sidebarDefinition,
        }));
    }, [cardDefinition, columns, dispatch, elementId, level, screenId, sidebarDefinition]);
    const addItemUsingSidebarLabel = localize('@sage/xtrem-ui/add-item-in-line-using-sidebar', 'Add item in sidebar');
    const addItemUsingCustomActionLabel = localize('@sage/xtrem-ui/add-item-using-custom-action', 'Add from');
    const shouldRenderAddUsingSidebar = !!hasSidebar && !!canAddNewLine;
    const shouldRenderCustomActions = visibleAddItemActions.length > 0;
    if (shouldRenderAddUsingSidebar || shouldRenderCustomActions) {
        return (React.createElement("div", { className: "e-table-field-add-item-actions-bar", "data-testid": "e-table-add-item-actions-bar" },
            shouldRenderAddUsingSidebar && (React.createElement(Button, { "aria-label": addItemUsingSidebarLabel, buttonType: "primary", className: "e-table-button-add-new-row-sidebar", "data-pendoid": `addTableLineWithSidebarButton-${screenId}-${elementId}`, "data-testid": "e-table-button-add-new-row-sidebar", disabled: isDisabled, iconType: "add", onClick: onOpenSidebarClick }, addItemUsingSidebarLabel)),
            visibleAddItemActions.length === 1 && (React.createElement(BusinessAction, { alwaysTriggerFieldEvent: true, buttonTypeOverride: "secondary", className: "e-table-button-add-new-row-single-action", "data-testid": `e-table-button-add-new-row-single-action e-business-action-field e-field-bind-${visibleAddItemActions[0].id} e-field-label-${camelCase(visibleAddItemActions[0].title)}`, "data-pendoid": `addTableLineWithSingleActionButton-${elementId}`, disabled: isDisabled, id: visibleAddItemActions[0].id, key: visibleAddItemActions[0].id, screenId: screenId, skipWrapping: true })),
            visibleAddItemActions.length > 1 && (React.createElement(MultiActionButton, { buttonType: "secondary", "data-pendoid": `addTableLineWithMultiActionButton-${elementId}`, "data-testid": "e-table-button-add-new-row-multi-action", disabled: isDisabled, mr: "16px", text: addItemUsingCustomActionLabel }, visibleAddItemActions.map(a => (React.createElement(BusinessAction, { alwaysTriggerFieldEvent: true, buttonTypeOverride: "secondary", id: a.id, key: a.id, screenId: screenId, skipWrapping: true })))))));
    }
    return null;
});
DesktopTableAddNewRowButton.displayName = 'DesktopTableAddNewRowButton';
//# sourceMappingURL=desktop-table-add-new-row-button.js.map